import crafttweaker.api.item.IItemStack;
import crafttweaker.api.ingredient.IIngredient;
import crafttweaker.api.data.IData;

function addSingleSAGMill(uniqueID as string, itemIn as IIngredient, itemOut as IItemStack, powerRequired as int) as void {
	<recipetype:enderio:sag_milling>.addJsonRecipe("sagmilling_" + uniqueID, {
		"type": "enderio:sag_milling",
		"energy": powerRequired,
		"input": itemIn as IData,
		"outputs": [itemOut as IData]
	});
}

function addDoubleSAGMill(uniqueID as string, itemIn as IIngredient, itemOut1 as IItemStack, itemOut2 as IItemStack, powerRequired as int) as void {
	<recipetype:enderio:sag_milling>.addJsonRecipe("sagmilling_" + uniqueID, {
		"type": "enderio:sag_milling",
		"energy": powerRequired,
		"input": itemIn as IData,
		"outputs": [itemOut1 as IData, itemOut2 as IData]
	});
}


addSingleSAGMill("copper_ingot_to_dust", <tag:items:forge:ingots/copper>, <item:enderio:powdered_copper>, 2400);
addSingleSAGMill("silver_ingot_to_dust", <tag:items:forge:ingots/silver>, <item:occultism:silver_dust>, 2400);
addSingleSAGMill("osmium_ingot_to_dust", <tag:items:forge:ingots/osmium>, <item:mekanism:dust_osmium>, 2400);
addSingleSAGMill("certus_quartz_to_dust", <tag:items:ae2:all_certus_quartz>, <item:ae2:certus_quartz_dust>, 2400);
addDoubleSAGMill("redstone_lamp_to_dust", <item:minecraft:redstone_lamp>, <item:minecraft:redstone> * 4, <item:minecraft:glowstone_dust> * 4, 10000);