/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.util;

import com.blamejared.jeitweaker.common.platform.PlatformBridge;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public final class EnvironmentVerifier {
    private static final String JEI = "jei";
    private static final String REI = "roughlyenoughitems";
    private static final String REI_PC = "rei_plugin_compatibilities";
    private static final List<ModEnvironment> ENVIRONMENTS = List.of(new ModEnvironment(new ModList("jei"), EnvironmentSupport.FULL), new ModEnvironment(new ModList(Set.of("roughlyenoughitems", "rei_plugin_compatibilities")), EnvironmentSupport.PARTIAL), new ModEnvironment(new ModList(Set.of("roughlyenoughitems")), EnvironmentSupport.NONE), new ModEnvironment(new ModList(new String[0]), EnvironmentSupport.NONE));

    private EnvironmentVerifier() {
    }

    public static void scanAndReportEnvironment(Logger reportTo) {
        for (ModEnvironment environment : ENVIRONMENTS) {
            if (!environment.matches()) continue;
            environment.report(reportTo);
            break;
        }
    }

    private record ModEnvironment(ModList list, EnvironmentSupport support, String specialMessage) {
        ModEnvironment(ModList list, EnvironmentSupport support) {
            this(list, support, null);
        }

        boolean matches() {
            return this.list().matches();
        }

        void report(Logger logger) {
            String message = "JEITweaker Environmental Check: %s".formatted(this.support().message(this.list(), this.specialMessage()));
            logger.log(this.support().level(), message);
        }
    }

    private record ModList(Set<String> names) {
        ModList(String ... mods) {
            this(Set.of(mods));
        }

        boolean matches() {
            for (String name : this.names()) {
                if (PlatformBridge.INSTANCE.isModLoaded(name)) continue;
                return false;
            }
            return true;
        }
    }

    private static enum EnvironmentSupport {
        FULL(Level.INFO, "the combination of mods %s is fully supported%s"),
        PARTIAL(Level.WARN, "the combination of mods %s is partially supported: some features might be missing or performance might be degraded%s"),
        NONE(Level.ERROR, "the combination of mods %s is unsupported: no features will behave correctly%s");

        private final Level level;
        private final String formatMessage;

        private EnvironmentSupport(Level level, String formatMessage) {
            this.level = level;
            this.formatMessage = formatMessage;
        }

        Level level() {
            return this.level;
        }

        String message(ModList mods, String specialMessage) {
            return this.formatMessage.formatted(mods.names(), specialMessage == null ? "" : "; " + specialMessage);
        }
    }
}

