/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.plugin.core;

import com.blamejared.jeitweaker.common.api.plugin.JeiIngredientTypeRegistration;
import com.blamejared.jeitweaker.common.api.plugin.JeiTweakerPluginProvider;
import com.google.common.base.Suppliers;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Supplier;

final class LazyPlugin
implements JeiTweakerPluginProvider {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final MethodType CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE);
    private static final MethodType INVOKER_TYPE = MethodType.methodType(JeiTweakerPluginProvider.class);
    private final Supplier<JeiTweakerPluginProvider> plugin = Suppliers.memoize(plugin::get);

    private LazyPlugin(Supplier<JeiTweakerPluginProvider> plugin) {
    }

    static JeiTweakerPluginProvider of(Class<? extends JeiTweakerPluginProvider> clazz) {
        try {
            MethodHandle constructorHandle = LOOKUP.findConstructor(clazz, CONSTRUCTOR_TYPE);
            MethodHandle adaptedHandle = constructorHandle.asType(INVOKER_TYPE);
            return new LazyPlugin(() -> {
                try {
                    return adaptedHandle.invokeExact();
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Unable to construct plugin instance for " + clazz.getName(), t);
                }
            });
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("Invalid plugin class " + clazz.getName() + ": missing empty constructor", e);
        }
    }

    @Override
    public void initialize() {
        this.plugin().initialize();
    }

    @Override
    public void registerIngredientTypes(JeiIngredientTypeRegistration registration) {
        this.plugin().registerIngredientTypes(registration);
    }

    private JeiTweakerPluginProvider plugin() {
        return this.plugin.get();
    }
}

