/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

@Deprecated
public abstract class Zone
implements Comparable<Zone> {
    public static Zone rectangular(BlockPos minCoords, BlockPos maxCoords) {
        return new RectangularCuboidZone(minCoords, maxCoords);
    }

    public static Zone sphere(BlockPos center, int radius) {
        return new SphereZone(center, radius);
    }

    public abstract boolean contains(BlockPos var1);

    public abstract AABB getBoundingBox();

    @Override
    public int compareTo(Zone zone) {
        AABB myBB = this.getBoundingBox();
        AABB hisBB = zone.getBoundingBox();
        return 0;
    }

    private static class RectangularCuboidZone
    extends Zone {
        private final BlockPos _minCoords;
        private final BlockPos _maxCoords;

        RectangularCuboidZone(BlockPos minCoords, BlockPos maxCoords) {
            this._minCoords = minCoords;
            this._maxCoords = maxCoords;
        }

        @Override
        public boolean contains(BlockPos position) {
            return this._minCoords.m_123341_() <= position.m_123341_() && position.m_123341_() <= this._maxCoords.m_123341_() && this._minCoords.m_123342_() <= position.m_123342_() && position.m_123342_() <= this._maxCoords.m_123342_() && this._minCoords.m_123343_() <= position.m_123343_() && position.m_123343_() <= this._maxCoords.m_123343_();
        }

        @Override
        public AABB getBoundingBox() {
            return new AABB(this._minCoords, this._maxCoords);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RectangularCuboidZone)) {
                return false;
            }
            RectangularCuboidZone other = (RectangularCuboidZone)o;
            return this._minCoords.equals((Object)other._minCoords) && this._maxCoords.equals((Object)other._maxCoords);
        }
    }

    private static class SphereZone
    extends Zone {
        private final BlockPos _center;
        private final int _radius;

        SphereZone(BlockPos center, int radius) {
            this._center = center;
            this._radius = radius;
        }

        @Override
        public boolean contains(BlockPos position) {
            return (position.m_123341_() - this._center.m_123341_()) * (position.m_123341_() - this._center.m_123341_()) + (position.m_123342_() - this._center.m_123342_()) * (position.m_123342_() - this._center.m_123342_()) + (position.m_123343_() - this._center.m_123343_()) * (position.m_123343_() - this._center.m_123343_()) <= this._radius * this._radius;
        }

        @Override
        public AABB getBoundingBox() {
            int centerX = this._center.m_123341_();
            int centerY = this._center.m_123342_();
            int centerZ = this._center.m_123343_();
            return new AABB((double)(centerX - this._radius), (double)(centerY - this._radius), (double)(centerZ - this._radius), (double)(centerX + this._radius - 1), (double)(centerY + this._radius - 1), (double)(centerZ + this._radius - 1));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SphereZone)) {
                return false;
            }
            SphereZone other = (SphereZone)o;
            return this._radius == other._radius && this._center.equals((Object)other._center);
        }
    }
}

