/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractModRecipeBuilder<Builder extends AbstractModRecipeBuilder<Builder>> {
    private final List<ICondition> _conditions;
    private final Advancement.Builder _advancementBuilder;
    private final ResourceLocation _serializerId;

    protected AbstractModRecipeBuilder(ResourceLocation serializerId) {
        Preconditions.checkNotNull((Object)serializerId, (Object)"Serializer ID must not be null");
        this._serializerId = serializerId;
        this._advancementBuilder = Advancement.Builder.m_138353_();
        this._conditions = new ObjectArrayList(8);
    }

    protected abstract FinishedRecipe getFinishedRecipe(ResourceLocation var1);

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.hasCriteria()) {
            this._advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        }
        consumer.accept(this.getFinishedRecipe(id));
    }

    public Builder addCriterion(String name, CriterionTriggerInstance criterionIn) {
        this._advancementBuilder.m_138386_(name, criterionIn);
        return this.self();
    }

    public boolean hasCriteria() {
        return !this._advancementBuilder.m_138405_().isEmpty();
    }

    public Builder addCondition(ICondition condition) {
        this._conditions.add(condition);
        return this.self();
    }

    private Builder self() {
        return (Builder)this;
    }

    protected abstract class AbstractFinishedRecipe
    implements FinishedRecipe {
        private final ResourceLocation _id;

        public AbstractFinishedRecipe(ResourceLocation id) {
            this._id = id;
        }

        public JsonObject m_125966_() {
            JsonObject json = new JsonObject();
            JSONHelper.jsonSetResourceLocation(json, "type", AbstractModRecipeBuilder.this._serializerId);
            if (!AbstractModRecipeBuilder.this._conditions.isEmpty()) {
                json.add("conditions", (JsonElement)AbstractModRecipeBuilder.this._conditions.stream().map(CraftingHelper::serialize).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
            }
            this.m_7917_(json);
            return json;
        }

        public ResourceLocation m_6445_() {
            return this._id;
        }

        public RecipeSerializer<?> m_6637_() {
            return Objects.requireNonNull((RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(AbstractModRecipeBuilder.this._serializerId), () -> "Unknown recipe serializer: " + AbstractModRecipeBuilder.this._serializerId);
        }

        @Nullable
        public JsonObject m_5860_() {
            return AbstractModRecipeBuilder.this.hasCriteria() ? AbstractModRecipeBuilder.this._advancementBuilder.m_138400_() : null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return new ResourceLocation(this._id.m_135827_(), "recipes/" + this._id.m_135815_());
        }
    }
}

