/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.AbstractDataProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ModelBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.MultiPartBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.MultiVariantBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.SingleVariantBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;

public abstract class BlockStateDataProvider
extends AbstractDataProvider {
    private final Map<Block, BlockStateGenerator> _generators;
    private final ModelBuilder _models;
    private final PackOutput.PathProvider _pathProvider;
    private final ResourceLocationBuilder _blocksRoot;
    private final ResourceLocationBuilder _itemsRoot;

    public BlockStateDataProvider(String name, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ResourceLocationBuilder modLocationRoot) {
        super(name, output, lookupProvider, modLocationRoot);
        this._pathProvider = output.m_245269_(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this._generators = new Object2ObjectArrayMap(128);
        this._models = new ModelBuilder(output);
        this._blocksRoot = modLocationRoot.appendPath("block/");
        this._itemsRoot = modLocationRoot.appendPath("item/");
    }

    public ResourceLocationBuilder blocksRoot() {
        return this._blocksRoot;
    }

    public ResourceLocationBuilder itemsRoot() {
        return this._itemsRoot;
    }

    public final ModelBuilder models() {
        return this._models;
    }

    public <B extends Block> SingleVariantBuilder singleVariant(B block) {
        return this.add(new SingleVariantBuilder(this._models, block));
    }

    public <B extends Block> SingleVariantBuilder singleVariant(Supplier<B> block) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        return this.singleVariant((Block)block.get());
    }

    public <B extends Block> MultiVariantBuilder multiVariant(B block) {
        return this.add(new MultiVariantBuilder(this._models, block));
    }

    public <B extends Block> MultiVariantBuilder multiVariant(B block, Property<?> ... ignoredProperties) {
        return this.add(new MultiVariantBuilder(this._models, block, (Set<Property<?>>)ImmutableSet.copyOf((Object[])ignoredProperties)));
    }

    public <B extends Block> MultiVariantBuilder multiVariant(Supplier<B> block) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        return this.multiVariant((Block)block.get());
    }

    public <B extends Block> MultiVariantBuilder multiVariant(Supplier<B> block, Property<?> ... ignoredProperties) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        return this.multiVariant((Block)block.get(), ignoredProperties);
    }

    public <B extends Block> MultiPartBuilder multiPart(B block) {
        return this.add(new MultiPartBuilder(this._models, block));
    }

    public <B extends Block> MultiPartBuilder multiPart(Supplier<B> block) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        return this.multiPart((Block)block.get());
    }

    public <B extends Block> ResourceLocation defaultBlockTexture(Supplier<B> block) {
        return this.models().defaultBlockTexture(block);
    }

    public <I extends ItemLike> ResourceLocation defaultItemTexture(Supplier<I> item) {
        return this.models().defaultItemTexture(item);
    }

    public <B extends Block> void simpleBlock(Supplier<B> block) {
        this.cube(block, this.defaultBlockTexture(block));
    }

    public <I extends ItemLike> void simpleItem(Supplier<I> item) {
        this.models().item(item).flatItem(this.defaultItemTexture(item));
    }

    public <B extends Block> void axisAligned(Supplier<B> block, NonNullFunction<Direction.Axis, ResourceLocation> modelProvider) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        Preconditions.checkNotNull(modelProvider, (Object)"Model provider must not be null");
        this.multiVariant(block).selector(BlockStateProperties.f_61365_, Direction.Axis.X, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model((ResourceLocation)modelProvider.apply((Object)Direction.Axis.X)).xRotation(90).yRotation(90))).selector(BlockStateProperties.f_61365_, Direction.Axis.Y, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model((ResourceLocation)modelProvider.apply((Object)Direction.Axis.Y)))).selector(BlockStateProperties.f_61365_, Direction.Axis.Z, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model((ResourceLocation)modelProvider.apply((Object)Direction.Axis.Z)).xRotation(90)));
    }

    public <B extends Block> void axisAligned(Supplier<B> block, ResourceLocation model) {
        this.axisAligned(block, (NonNullFunction<Direction.Axis, ResourceLocation>)((NonNullFunction)$ -> model));
    }

    public <B extends Block> void cube(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation model = this.models().block(block).delegateFor(block).cube(texture);
        this.singleVariant(block).model(model);
    }

    public <B extends Block> void wood(Supplier<B> block, ResourceLocation texture) {
        this.axisAligned(block, this.models().block(block).delegateFor(block).wood(texture));
    }

    public <B extends Block> void woodLog(Supplier<B> block, ResourceLocation side, ResourceLocation ends) {
        ResourceLocation vertical = this.models().block(block).delegateFor(block).woodVerticalLog(side, ends);
        ResourceLocation horizontal = this.models().block(block, "_horizontal").woodHorizontalLog(side, ends);
        this.axisAligned(block, (NonNullFunction<Direction.Axis, ResourceLocation>)((NonNullFunction)axis -> axis.m_122478_() ? vertical : horizontal));
    }

    public <B extends Block> void woodPlanks(Supplier<B> block, ResourceLocation texture) {
        this.singleVariant(block).model(this.models().block(block).delegateFor(block).woodPLanks(texture));
    }

    public <B extends DoorBlock> void door(Supplier<B> block, ResourceLocation bottomTexture, ResourceLocation topTexture, ResourceLocation itemTexture) {
        ResourceLocation[] models = new ResourceLocation[]{this.models().block(block, "_bottom_left").doorClosedBottomLeft(bottomTexture), this.models().block(block, "_bottom_right").doorClosedBottomRight(bottomTexture), this.models().block(block, "_top_left").doorClosedTopLeft(topTexture), this.models().block(block, "_top_right").doorClosedTopRight(topTexture), this.models().block(block, "_bottom_left_open").doorOpenBottomLeft(bottomTexture), this.models().block(block, "_bottom_right_open").doorOpenBottomRight(bottomTexture), this.models().block(block, "_top_left_open").doorOpenTopLeft(topTexture), this.models().block(block, "_top_right_open").doorOpenTopRight(topTexture)};
        this.multiVariant(block, new Property[]{DoorBlock.f_52729_}).all((state, builder) -> {
            DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
            boolean isOpen = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            int modelIndex = 0;
            int yRotation = 90 + (int)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122435_();
            if (DoorHingeSide.RIGHT == hinge) {
                modelIndex |= 1;
            }
            if (DoubleBlockHalf.UPPER == state.m_61143_((Property)DoorBlock.f_52730_)) {
                modelIndex |= 2;
            }
            if (isOpen) {
                modelIndex |= 4;
                yRotation += 90;
                if (DoorHingeSide.RIGHT == hinge) {
                    yRotation += 180;
                }
            }
            builder.model(models[modelIndex]).yRotation(yRotation %= 360);
        });
        this.models().item(block).doorItem(itemTexture);
    }

    public <B extends Block> void button(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation nonPressed = this.models().block(block).button(false, texture);
        ResourceLocation pressed = this.models().block(block, "_pressed").button(true, texture);
        this.multiVariant(block).all((state, builder) -> {
            ResourceLocation model = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? pressed : nonPressed;
            VariantProperties.Rotation xRotation = VariantProperties.Rotation.R0;
            VariantProperties.Rotation yRotation = VariantProperties.Rotation.R0;
            boolean uvLock = false;
            switch ((AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_)) {
                case CEILING: {
                    xRotation = VariantProperties.Rotation.R180;
                    yRotation = switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
                        case Direction.EAST -> VariantProperties.Rotation.R270;
                        case Direction.WEST -> VariantProperties.Rotation.R90;
                        case Direction.SOUTH -> VariantProperties.Rotation.R0;
                        case Direction.NORTH -> VariantProperties.Rotation.R180;
                        default -> throw new IllegalArgumentException("Invalid facing");
                    };
                    break;
                }
                case WALL: {
                    uvLock = true;
                    xRotation = VariantProperties.Rotation.R90;
                    yRotation = switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
                        case Direction.EAST -> VariantProperties.Rotation.R90;
                        case Direction.WEST -> VariantProperties.Rotation.R270;
                        case Direction.SOUTH -> VariantProperties.Rotation.R180;
                        case Direction.NORTH -> VariantProperties.Rotation.R0;
                        default -> throw new IllegalArgumentException("Invalid facing");
                    };
                    break;
                }
                case FLOOR: {
                    yRotation = switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
                        case Direction.EAST -> VariantProperties.Rotation.R90;
                        case Direction.WEST -> VariantProperties.Rotation.R270;
                        case Direction.SOUTH -> VariantProperties.Rotation.R180;
                        case Direction.NORTH -> VariantProperties.Rotation.R0;
                        default -> throw new IllegalArgumentException("Invalid facing");
                    };
                }
            }
            builder.model(model).xRotation(xRotation).yRotation(yRotation).uvLock(uvLock);
        });
        this.models().item(block).buttonItem(texture);
    }

    public <B extends Block> void fence(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation post = this.models().block(block, "_post").fencePost(texture);
        ResourceLocation side = this.models().block(block, "_side").fenceSide(texture);
        this.multiPart(block).part((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(post))).part(BlockStateProperties.f_61368_, Boolean.valueOf(true), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(side).uvLock())).part(BlockStateProperties.f_61369_, Boolean.valueOf(true), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(side).uvLock().yRotation(VariantProperties.Rotation.R90))).part(BlockStateProperties.f_61370_, Boolean.valueOf(true), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(side).uvLock().yRotation(VariantProperties.Rotation.R180))).part(BlockStateProperties.f_61371_, Boolean.valueOf(true), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(side).uvLock().yRotation(VariantProperties.Rotation.R270)));
        this.models().item(block).fenceItem(texture);
    }

    public <B extends Block> void fenceGate(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation[] models = new ResourceLocation[]{this.models().block(block).delegateFor(block).fenceGateClosed(texture), this.models().block(block, "_open").fenceGateOpen(texture), this.models().block(block, "_wall").fenceGateWallClosed(texture), this.models().block(block, "_wall_open").fenceGateWallOpen(texture)};
        this.multiVariant(block).all((state, builder) -> {
            ModelVariantBuilder modelVariantBuilder = builder.model(models[((Boolean)state.m_61143_((Property)BlockStateProperties.f_61442_) != false ? 2 : 0) + ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_) != false ? 1 : 0)]).uvLock();
            modelVariantBuilder.yRotation(switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
                case Direction.EAST -> VariantProperties.Rotation.R270;
                case Direction.NORTH -> VariantProperties.Rotation.R180;
                case Direction.WEST -> VariantProperties.Rotation.R90;
                case Direction.SOUTH -> VariantProperties.Rotation.R0;
                default -> throw new IllegalStateException("Invalid facing value");
            });
        });
    }

    public <B extends Block> void wall(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation post = this.models().block(block, "_post").wallPost(texture);
        ResourceLocation lowSide = this.models().block(block, "_side").wallLowSide(texture);
        ResourceLocation tallSide = this.models().block(block, "_side_tall").wallTallSide(texture);
        this.multiPart(block).part(BlockStateProperties.f_61366_, Boolean.valueOf(true), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(post))).part(BlockStateProperties.f_61379_, WallSide.LOW, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(lowSide).uvLock())).part(BlockStateProperties.f_61378_, WallSide.LOW, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(lowSide).uvLock().yRotation(90))).part(BlockStateProperties.f_61380_, WallSide.LOW, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(lowSide).uvLock().yRotation(180))).part(BlockStateProperties.f_61381_, WallSide.LOW, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(lowSide).uvLock().yRotation(270))).part(BlockStateProperties.f_61379_, WallSide.TALL, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(tallSide).uvLock())).part(BlockStateProperties.f_61378_, WallSide.TALL, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(tallSide).uvLock().yRotation(90))).part(BlockStateProperties.f_61380_, WallSide.TALL, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(tallSide).uvLock().yRotation(180))).part(BlockStateProperties.f_61381_, WallSide.TALL, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(tallSide).uvLock().yRotation(270)));
        this.models().item(block).wallItem(texture);
    }

    public <B extends Block> void pressurePlate(Supplier<B> block, ResourceLocation texture) {
        this.multiVariant(block).selector(BlockStateProperties.f_61448_, Boolean.valueOf(false), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model((NonNullFunction<ModelBuilder, ResourceLocation>)((NonNullFunction)arg_0 -> BlockStateDataProvider.lambda$pressurePlate$22((Supplier)block, texture, arg_0))))).selector(BlockStateProperties.f_61448_, Boolean.valueOf(true), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model((NonNullFunction<ModelBuilder, ResourceLocation>)((NonNullFunction)arg_0 -> BlockStateDataProvider.lambda$pressurePlate$24((Supplier)block, texture, arg_0)))));
    }

    public void slab(Supplier<SlabBlock> block, ResourceLocation doubleSlabsModel, ResourceLocation texture) {
        this.slab(block, doubleSlabsModel, texture, texture, texture);
    }

    public void slab(Supplier<SlabBlock> block, ResourceLocation doubleSlabsModel, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        this.multiVariant(block, new Property[]{BlockStateProperties.f_61362_}).selector(SlabBlock.f_56353_, SlabType.BOTTOM, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model((NonNullFunction<ModelBuilder, ResourceLocation>)((NonNullFunction)arg_0 -> BlockStateDataProvider.lambda$slab$26((Supplier)block, bottom, top, side, arg_0))))).selector(SlabBlock.f_56353_, SlabType.TOP, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model((NonNullFunction<ModelBuilder, ResourceLocation>)((NonNullFunction)arg_0 -> BlockStateDataProvider.lambda$slab$28((Supplier)block, bottom, top, side, arg_0))))).selector(SlabBlock.f_56353_, SlabType.DOUBLE, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(doubleSlabsModel)));
    }

    public <B extends Block> void leaves(Supplier<B> block, ResourceLocation texture) {
        this.singleVariant(block).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model((NonNullFunction<ModelBuilder, ResourceLocation>)((NonNullFunction)arg_0 -> BlockStateDataProvider.lambda$leaves$31((Supplier)block, texture, arg_0)))));
    }

    public void stairs(Supplier<StairBlock> block, ResourceLocation texture) {
        this.stairs(block, texture, texture, texture);
    }

    public void stairs(Supplier<StairBlock> block, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        ResourceLocation straight = this.models().block(block).delegateFor(block).stairsStraight(bottom, top, side);
        ResourceLocation inner = this.models().block(block, "_inner").stairsInner(bottom, top, side);
        ResourceLocation outer = this.models().block(block, "_outer").stairsOuter(bottom, top, side);
        this.multiVariant(block, new Property[]{StairBlock.f_56844_}).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.EAST).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.INNER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().yRotation(270))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.EAST).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.INNER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.EAST).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.OUTER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().yRotation(270))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.EAST).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.OUTER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.EAST).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.STRAIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(straight))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.EAST).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.INNER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().xRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.EAST).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.INNER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().xRotation(180).yRotation(90))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.EAST).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.OUTER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().xRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.EAST).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.OUTER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().xRotation(180).yRotation(90))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.EAST).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.STRAIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(straight).uvLock().xRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.NORTH).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.INNER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().yRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.NORTH).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.INNER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().yRotation(270))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.NORTH).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.OUTER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().yRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.NORTH).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.OUTER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().yRotation(270))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.NORTH).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.STRAIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(straight).uvLock().yRotation(270))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.NORTH).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.INNER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().xRotation(180).yRotation(270))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.NORTH).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.INNER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().xRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.NORTH).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.OUTER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().xRotation(180).yRotation(270))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.NORTH).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.OUTER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().xRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.NORTH).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.STRAIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(straight).uvLock().xRotation(180).yRotation(270))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.SOUTH).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.INNER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.SOUTH).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.INNER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().yRotation(90))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.SOUTH).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.OUTER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.SOUTH).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.OUTER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().yRotation(90))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.SOUTH).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.STRAIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(straight).uvLock().yRotation(90))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.SOUTH).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.INNER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().xRotation(180).yRotation(90))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.SOUTH).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.INNER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().xRotation(180).yRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.SOUTH).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.OUTER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().xRotation(180).yRotation(90))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.SOUTH).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.OUTER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().xRotation(180).yRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.SOUTH).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.STRAIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(straight).uvLock().xRotation(180).yRotation(90))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.WEST).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.INNER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().yRotation(90))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.WEST).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.INNER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().yRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.WEST).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.OUTER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().yRotation(90))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.WEST).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.OUTER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().yRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.WEST).state(StairBlock.f_56842_, Half.BOTTOM).state(StairBlock.f_56843_, StairsShape.STRAIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(straight).uvLock().yRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.WEST).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.INNER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().xRotation(180).yRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.WEST).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.INNER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(inner).uvLock().xRotation(180).yRotation(270))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.WEST).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.OUTER_LEFT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().xRotation(180).yRotation(180))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.WEST).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.OUTER_RIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(outer).uvLock().xRotation(180).yRotation(270))))).selector((NonNullConsumer<MultiVariantBuilder.SelectorBuilder>)((NonNullConsumer)selector -> selector.state(StairBlock.f_56841_, Direction.WEST).state(StairBlock.f_56842_, Half.TOP).state(StairBlock.f_56843_, StairsShape.STRAIGHT).variant((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(straight).uvLock().xRotation(180).yRotation(180)))));
    }

    public void trapdoor(Supplier<TrapDoorBlock> block, boolean orientable, ResourceLocation texture) {
        ResourceLocation bottom = this.models().block(block, "_bottom").delegateFor(block).trapdoorBottom(orientable, texture);
        ResourceLocation top = this.models().block(block, "_top").trapdoorTop(orientable, texture);
        ResourceLocation open = this.models().block(block, "_open").trapdoorOpen(orientable, texture);
        this.multiVariant(block, new Property[]{TrapDoorBlock.f_57516_, TrapDoorBlock.f_57517_}).all((state, builder) -> {
            boolean isOpen = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
            boolean isTop = Half.TOP == state.m_61143_((Property)TrapDoorBlock.f_57515_);
            int xRotation = 0;
            int yRotation = 180 + (int)((Direction)state.m_61143_((Property)TrapDoorBlock.f_54117_)).m_122435_();
            if (orientable && isOpen) {
                if (isTop) {
                    xRotation += 180;
                    yRotation += 180;
                }
            } else {
                yRotation = 0;
            }
            builder.model(isOpen ? open : (isTop ? top : bottom)).xRotation(xRotation).yRotation(yRotation %= 360);
        });
    }

    public <B extends Block> void passiveRail(Supplier<B> block, ResourceLocation texture, ResourceLocation cornerTexture) {
        ResourceLocation flat = this.models().block(block).railFlat(texture);
        ResourceLocation corner = this.models().block(block, "_corner").railCorner(cornerTexture);
        ResourceLocation raisedNE = this.models().block(block, "_raised_ne").railRaisedNE(texture);
        ResourceLocation raisedSW = this.models().block(block, "_raised_sw").railRaisedSW(texture);
        this.multiVariant(block).all((state, builder) -> {
            ResourceLocation model = corner;
            int yRotation = 0;
            switch ((RailShape)state.m_61143_((Property)BlockStateProperties.f_61403_)) {
                case ASCENDING_EAST: {
                    yRotation = 90;
                }
                case ASCENDING_NORTH: {
                    model = raisedNE;
                    break;
                }
                case ASCENDING_WEST: {
                    yRotation = 90;
                }
                case ASCENDING_SOUTH: {
                    model = raisedSW;
                    break;
                }
                case EAST_WEST: {
                    yRotation = 90;
                }
                case NORTH_SOUTH: {
                    model = flat;
                    break;
                }
                case SOUTH_EAST: {
                    break;
                }
                case SOUTH_WEST: {
                    yRotation = 90;
                    break;
                }
                case NORTH_WEST: {
                    yRotation = 180;
                    break;
                }
                case NORTH_EAST: {
                    yRotation = 270;
                }
            }
            builder.model(model).yRotation(yRotation);
        });
        this.models().item(block).railItem(texture);
    }

    public <B extends Block> void activeRail(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation flat = this.models().block(block).railFlat(texture);
        ResourceLocation raisedNE = this.models().block(block, "_raised_ne").railRaisedNE(texture);
        ResourceLocation raisedSW = this.models().block(block, "_raised_sw").railRaisedSW(texture);
        ResourceLocation onFlat = this.models().block(block, "_on").railFlat(texture);
        ResourceLocation onRaisedNE = this.models().block(block, "_on_raised_ne").railRaisedNE(texture);
        ResourceLocation onRaisedSW = this.models().block(block, "_on_raised_sw").railRaisedSW(texture);
        this.multiVariant(block).all((state, builder) -> {
            ResourceLocation model;
            boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
            int yRotation = 0;
            switch ((RailShape)state.m_61143_((Property)BlockStateProperties.f_61404_)) {
                case ASCENDING_EAST: {
                    yRotation = 90;
                }
                case ASCENDING_NORTH: {
                    model = powered ? onRaisedNE : raisedNE;
                    break;
                }
                case ASCENDING_WEST: {
                    yRotation = 90;
                }
                case ASCENDING_SOUTH: {
                    model = powered ? onRaisedSW : raisedSW;
                    break;
                }
                case EAST_WEST: {
                    yRotation = 90;
                }
                case NORTH_SOUTH: {
                    model = powered ? onFlat : flat;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid rail shape");
                }
            }
            builder.model(model).yRotation(yRotation);
        });
        this.models().item(block).railItem(texture);
    }

    public <B extends Block> void glass(Supplier<B> block, ResourceLocation texture) {
        this.cube(block, texture);
    }

    public <B extends Block> void glassPane(Supplier<B> block, ResourceLocation pane, ResourceLocation edge) {
        ResourceLocation post = this.models().block(block, "_post").glassPanePost(pane, edge);
        ResourceLocation side = this.models().block(block, "_side").glassPaneSide(pane, edge);
        ResourceLocation sideAlt = this.models().block(block, "_side_alt").glassPaneSideAlt(pane, edge);
        ResourceLocation noSide = this.models().block(block, "_noside").glassPaneNoSide(pane);
        ResourceLocation noSideAlt = this.models().block(block, "_noside_alt").glassPaneNoSideAlt(pane);
        this.multiPart(block).part((NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(post))).part(BlockStateProperties.f_61368_, Boolean.valueOf(true), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(side))).part(BlockStateProperties.f_61368_, Boolean.valueOf(false), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(noSide))).part(BlockStateProperties.f_61370_, Boolean.valueOf(true), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(sideAlt))).part(BlockStateProperties.f_61370_, Boolean.valueOf(false), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(noSideAlt).yRotation(90))).part(BlockStateProperties.f_61371_, Boolean.valueOf(true), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(sideAlt).yRotation(90))).part(BlockStateProperties.f_61371_, Boolean.valueOf(false), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(noSide).yRotation(270))).part(BlockStateProperties.f_61369_, Boolean.valueOf(true), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(side).yRotation(90))).part(BlockStateProperties.f_61369_, Boolean.valueOf(false), (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)variant -> variant.model(noSideAlt)));
        this.models().item(block).glassPaneItem(pane);
    }

    @Override
    public CompletableFuture<?> processData(CachedOutput cache, HolderLookup.Provider registryLookup) {
        ObjectArrayList futures = new ObjectArrayList(1 + this._generators.size());
        futures.add(this._models.apply(cache));
        this._generators.entrySet().stream().map(entry -> DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)((BlockStateGenerator)entry.getValue()).get()), (Path)this._pathProvider.m_245731_(CodeHelper.getObjectId((Block)entry.getKey())))).forEachOrdered(((List)futures)::add);
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private <G extends BlockStateGenerator> G add(G generator) {
        Block block = generator.m_6968_();
        if (this._generators.containsKey(block)) {
            throw new IllegalStateException("A block state generator is already defined for block " + block);
        }
        this._generators.put(block, generator);
        return generator;
    }

    private static /* synthetic */ ResourceLocation lambda$leaves$31(Supplier block, ResourceLocation texture, ModelBuilder model) {
        return model.block(block).delegateFor(block).leaves(texture);
    }

    private static /* synthetic */ ResourceLocation lambda$slab$28(Supplier block, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ModelBuilder model) {
        return model.block(block, "_top").slab(true, bottom, top, side);
    }

    private static /* synthetic */ ResourceLocation lambda$slab$26(Supplier block, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ModelBuilder model) {
        return model.block(block).delegateFor(block).slab(false, bottom, top, side);
    }

    private static /* synthetic */ ResourceLocation lambda$pressurePlate$24(Supplier block, ResourceLocation texture, ModelBuilder model) {
        return model.block(block, "_down").pressurePlate(true, texture);
    }

    private static /* synthetic */ ResourceLocation lambda$pressurePlate$22(Supplier block, ResourceLocation texture, ModelBuilder model) {
        return model.block(block).delegateFor(block).pressurePlate(false, texture);
    }
}

