/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public enum TestResult implements BooleanSupplier
{
    SUCCESS,
    FAIL,
    SKIPPED;


    public boolean wasSkipped() {
        return this == SKIPPED;
    }

    public static TestResult from(boolean result) {
        return result ? SUCCESS : FAIL;
    }

    public static TestResult from(Optional<Boolean> test) {
        return test.map(TestResult::from).orElse(SKIPPED);
    }

    public static <T> TestResult from(Predicate<T> test, T argument) {
        return TestResult.from(test.test(argument));
    }

    @Override
    public boolean getAsBoolean() {
        if (this.wasSkipped()) {
            throw new IllegalArgumentException("Returning a result from a skipped test");
        }
        return this == SUCCESS;
    }
}

