/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.network;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.DimensionId;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class Connection {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private final SimpleChannel channel;
    private int index = 0;

    public Connection(String modId, AbstractForgeMod.RequiredSide requiredSide) {
        ResourceLocation name = new ResourceLocation(modId, "main");
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)name).clientAcceptedVersions(Connection.acceptMissingIf(requiredSide == AbstractForgeMod.RequiredSide.CLIENT)).serverAcceptedVersions(Connection.acceptMissingIf(requiredSide == AbstractForgeMod.RequiredSide.SERVER)).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }

    public static Predicate<String> acceptMissingIf(boolean condition) {
        return version -> {
            if (version.equals(PROTOCOL_VERSION)) {
                return true;
            }
            if (condition) {
                return version.equals(NetworkRegistry.ABSENT.version()) || version.equals(NetworkRegistry.ACCEPTVANILLA);
            }
            return false;
        };
    }

    public <MSG extends ForgeNetMsg<MSG>> void registerNetMessage(MSG msg) {
        Class<?> msgType = msg.getClass();
        this.channel.registerMessage(this.index++, msgType, msg::encode, msg::decode, msg::handle);
    }

    public <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        if (player instanceof FakePlayer) {
            return;
        }
        this.channel.sendTo(message, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public <MSG> void sendToServer(MSG message) {
        this.channel.sendToServer(message);
    }

    public <MSG> void sendToAll(MSG message) {
        this.getServerPlayers().forEach(player -> this.sendToPlayer(message, (ServerPlayer)player));
    }

    public <MSG> void sendToAllInDimension(MSG message, DimensionId dimension) {
        for (ServerPlayer player : this.getServerPlayers()) {
            if (!dimension.belongsTo(player.m_9236_())) continue;
            this.sendToPlayer(message, player);
        }
    }

    public <MSG> void sendToAllAround(MSG message, ServerLevelAccessor world, BlockPos pos, int radius) {
        DimensionId dimension = DimensionId.from((Level)world.m_6018_());
        for (ServerPlayer player : this.getServerPlayers()) {
            double distSqr;
            if (!dimension.belongsTo(player.m_9236_()) || !((distSqr = pos.m_123331_((Vec3i)player.m_20183_())) <= (double)(radius * radius))) continue;
            this.sendToPlayer(message, player);
        }
    }

    public <MSG> void sendToAllObservingChunk(MSG message, LevelChunk chunk) {
        this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), message);
    }

    public <MSG> void sendToAllAround(MSG message, PacketDistributor.TargetPoint point) {
        this.channel.send(PacketDistributor.NEAR.with(() -> point), message);
    }

    public <MSG> void sendToAllInChunk(MSG message, ChunkLoc location) {
        for (ServerPlayer player : this.getServerPlayers()) {
            if (!location.contains((Entity)player)) continue;
            this.sendToPlayer(message, player);
        }
    }

    public List<ServerPlayer> getServerPlayers() {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
    }

    public <MSG> Packet<?> toVanillaPacket(MSG msg, NetworkDirection direction) {
        return this.channel.toVanillaPacket(msg, direction);
    }
}

