/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.utils;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.mixin.fields.ClientLevelMixin;
import com.mt1006.nbt_ac.mixin.fields.EntitySelectorMixin;
import com.mt1006.nbt_ac.utils.Fields;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MixinUtils {
    private static final CommandSourceStack DUMMY_COMMAND_SOURCE_STACK = new CommandSourceStack(null, Vec3.f_82478_, Vec2.f_82462_, null, 0, null, null, null, null);

    public static String getNodeString(CommandContext<?> commandContext, int pos) {
        return ((ParsedCommandNode)commandContext.getNodes().get(pos)).getNode().getName();
    }

    public static String getCommandName(CommandContext<?> commandContext) {
        String name = MixinUtils.getNodeString(commandContext, 0);
        if (ModConfig.supportCommandNamespace.getValue().booleanValue() && name.startsWith("minecraft:")) {
            return name.substring(10);
        }
        return name;
    }

    public static String getArgumentString(CommandContext<?> commandContext, String argumentName) {
        Map arguments;
        try {
            arguments = (Map)Fields.commandContextArguments.get(commandContext);
        }
        catch (Exception exception) {
            return null;
        }
        ParsedArgument argument = (ParsedArgument)arguments.get(argumentName);
        if (argument == null) {
            return null;
        }
        return argument.getRange().get(commandContext.getInput());
    }

    public static String blockFromCoords(Coordinates coords) {
        if (!(coords instanceof WorldCoordinates)) {
            return null;
        }
        if (coords.m_6888_() || coords.m_6892_() || coords.m_6900_()) {
            return null;
        }
        BlockPos blockPos = coords.m_119568_(DUMMY_COMMAND_SOURCE_STACK);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        Block block = level.m_8055_(blockPos).m_60734_();
        return "block/" + RegistryUtils.BLOCK.getKey(block);
    }

    public static String entityFromEntitySelector(EntitySelector entitySelector) {
        return MixinUtils.entityFromSelectorData(((EntitySelectorMixin)entitySelector).getType(), ((EntitySelectorMixin)entitySelector).getEntityUUID(), ((EntitySelectorMixin)entitySelector).getPlayerName());
    }

    public static String entityFromSelectorData(EntityTypeTest<Entity, ?> typeTest, @Nullable UUID uuid, @Nullable String playerName) {
        if (typeTest instanceof EntityType) {
            return "entity/" + RegistryUtils.ENTITY_TYPE.getKey((EntityType)typeTest);
        }
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel == null) {
            return null;
        }
        if (uuid != null) {
            try {
                TransientEntitySectionManager<Entity> entityStorage = ((ClientLevelMixin)clientLevel).getEntityStorage();
                Entity entity = (Entity)entityStorage.m_157645_().m_142694_(uuid);
                if (entity == null) {
                    return null;
                }
                return "entity/" + RegistryUtils.ENTITY_TYPE.getKey(entity.m_6095_());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (playerName == null) {
            return null;
        }
        for (Player player : clientLevel.m_6907_()) {
            if (!player.m_36316_().getName().equals(playerName)) continue;
            return "entity/" + EntityType.m_20613_((EntityType)EntityType.f_20532_);
        }
        return null;
    }
}

