/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.mixin.suggestions.selectors;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemParser.class})
public class ItemParserMixin {
    @Shadow
    @Final
    private StringReader f_120994_;
    @Shadow
    private Either<Holder<Item>, HolderSet<Item>> f_235289_;
    @Shadow
    @Nullable
    private CompoundTag f_120998_;
    @Shadow
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> f_121001_;

    @Inject(at={@At(value="HEAD")}, method={"readNbt"}, cancellable=true)
    protected void atReadNbt(CallbackInfo callbackInfo) throws CommandSyntaxException {
        callbackInfo.cancel();
        int cursorPos = this.f_120994_.getCursor();
        try {
            this.f_120998_ = new TagParser(this.f_120994_).m_129373_();
        }
        catch (CommandSyntaxException exception) {
            this.f_120994_.setCursor(cursorPos);
            this.f_121001_ = this::suggestNbt;
            throw exception;
        }
    }

    private CompletableFuture<Suggestions> suggestNbt(SuggestionsBuilder suggestionsBuilder) {
        Holder itemHolder = this.f_235289_.left().orElse(null);
        if (itemHolder == null) {
            return Suggestions.empty();
        }
        Item item = (Item)itemHolder.get();
        ResourceLocation resourceLocation = RegistryUtils.ITEM.getKey(item);
        String name = resourceLocation.toString();
        String tag = suggestionsBuilder.getRemaining();
        return NbtSuggestionManager.loadFromName("item/" + name, tag, suggestionsBuilder, false);
    }
}

