/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.mixin.suggestions.selectors;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockStateParser.class})
public class BlockStateParserMixin {
    @Shadow
    @Final
    private StringReader f_116749_;
    @Shadow
    @Nullable
    private BlockState f_116755_;
    @Shadow
    @Nullable
    private CompoundTag f_116756_;
    @Shadow
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> f_116759_;

    @Inject(method={"readNbt"}, at={@At(value="HEAD")}, cancellable=true)
    protected void atReadNbt(CallbackInfo callbackInfo) throws CommandSyntaxException {
        callbackInfo.cancel();
        int cursorPos = this.f_116749_.getCursor();
        try {
            this.f_116756_ = new TagParser(this.f_116749_).m_129373_();
        }
        catch (CommandSyntaxException exception) {
            this.f_116749_.setCursor(cursorPos);
            this.f_116759_ = this::suggestNbt;
            throw exception;
        }
    }

    private CompletableFuture<Suggestions> suggestNbt(SuggestionsBuilder suggestionsBuilder) {
        if (this.f_116755_ == null) {
            return Suggestions.empty();
        }
        ResourceLocation resourceLocation = RegistryUtils.BLOCK.getKey(this.f_116755_.m_60734_());
        String name = resourceLocation.toString();
        String tag = suggestionsBuilder.getRemaining();
        return NbtSuggestionManager.loadFromName("block/" + name, tag, suggestionsBuilder, false);
    }
}

