/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.mixin.suggestions.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.utils.MixinUtils;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={CompoundTagArgument.class})
public abstract class CompoundTagArgumentMixin
implements ArgumentType<CompoundTag> {
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        try {
            String name = this.getResourceName(commandContext);
            if (name == null) {
                return Suggestions.empty();
            }
            String tag = suggestionsBuilder.getRemaining();
            return NbtSuggestionManager.loadFromName(name, tag, suggestionsBuilder, false);
        }
        catch (Exception exception) {
            return Suggestions.empty();
        }
    }

    private String getResourceName(CommandContext<?> commandContext) {
        String commandName;
        switch (commandName = MixinUtils.getCommandName(commandContext)) {
            case "summon": {
                EntityType entityType = (EntityType)((Holder.Reference)commandContext.getArgument("entity", Holder.Reference.class)).m_203334_();
                ResourceLocation resourceLocation = EntityType.m_20613_((EntityType)entityType);
                return "entity/" + resourceLocation;
            }
            case "data": {
                return this.getResourceNameForDataCommand(commandContext);
            }
        }
        if (commandContext.getChild() != null) {
            return this.getResourceName(commandContext.getChild());
        }
        return null;
    }

    private String getResourceNameForDataCommand(CommandContext<?> commandContext) {
        String targetType;
        String instruction = MixinUtils.getNodeString(commandContext, 1);
        if (!instruction.equals("merge")) {
            return null;
        }
        switch (targetType = MixinUtils.getNodeString(commandContext, 2)) {
            case "block": {
                Coordinates coords = (Coordinates)commandContext.getArgument("targetPos", Coordinates.class);
                return MixinUtils.blockFromCoords(coords);
            }
            case "entity": {
                EntitySelector entitySelector = (EntitySelector)commandContext.getArgument("target", EntitySelector.class);
                return MixinUtils.entityFromEntitySelector(entitySelector);
            }
        }
        return null;
    }
}

