/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableByte;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableShort;

public class ConfigFile {
    private final File file;
    private final List<Field> fields = new ArrayList<Field>();
    private final Map<String, Field> fieldMap = new HashMap<String, Field>();

    public ConfigFile(File file) {
        this.file = file;
    }

    public void addValue(String name, Object reference, String description) {
        Field newField = new Field(name, reference, description);
        this.fields.add(newField);
        this.fieldMap.put(name, newField);
    }

    public void save() {
        this.file.getParentFile().mkdirs();
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.file)));){
            for (Field field : this.fields) {
                field.saveDescription(writer);
                writer.printf("%s = %s\n\n", field.name, field.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void load() {
        int loadedCount = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#' || StringUtils.isBlank((CharSequence)line)) continue;
                int equalSignPos = line.indexOf(61);
                if (equalSignPos == -1) {
                    throw new IOException();
                }
                String name = line.substring(0, equalSignPos).trim();
                String value = line.substring(equalSignPos + 1).trim();
                Field field = this.fieldMap.get(name);
                if (field == null) {
                    throw new IOException();
                }
                field.load(value);
                ++loadedCount;
            }
        }
        catch (IOException exception) {
            this.save();
        }
        if (loadedCount != this.fields.size()) {
            this.save();
        }
    }

    private static class Field {
        String name;
        Object ref;
        String desc;

        public Field(String name, Object reference, String description) {
            this.name = name;
            this.ref = reference;
            this.desc = description + "\nDefault value: " + this.getValue();
        }

        public String getValue() {
            if (this.ref instanceof StringBuffer) {
                return "\"" + this.ref + "\"";
            }
            return this.ref.toString();
        }

        public void saveDescription(PrintWriter writer) throws IOException {
            if (this.desc != null) {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(this.desc));
                while ((line = reader.readLine()) != null) {
                    writer.println("# " + line);
                }
            }
        }

        public void load(String value) throws IOException {
            try {
                if (this.ref instanceof MutableInt) {
                    ((MutableInt)this.ref).setValue(Integer.parseInt(value));
                } else if (this.ref instanceof MutableByte) {
                    ((MutableByte)this.ref).setValue(Byte.parseByte(value));
                } else if (this.ref instanceof MutableShort) {
                    ((MutableShort)this.ref).setValue(Short.parseShort(value));
                } else if (this.ref instanceof MutableLong) {
                    ((MutableLong)this.ref).setValue(Long.parseLong(value));
                } else if (this.ref instanceof MutableBoolean) {
                    ((MutableBoolean)this.ref).setValue(Boolean.valueOf(value));
                } else if (this.ref instanceof StringBuffer) {
                    this.parseStringBuffer((StringBuffer)this.ref, value);
                }
            }
            catch (NumberFormatException exception) {
                throw new IOException();
            }
        }

        private void parseStringBuffer(StringBuffer stringBuffer, String value) throws IOException {
            if (value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\"') {
                throw new IOException();
            }
            stringBuffer.setLength(0);
            stringBuffer.append(value, 1, value.length() - 1);
        }
    }
}

