/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.suggestions;

import com.mojang.brigadier.Message;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.loader.typeloader.Disassembly;
import com.mt1006.nbt_ac.autocomplete.suggestions.CustomSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.SimpleSuggestion;
import com.mt1006.nbt_ac.utils.ComparableLiteralMessage;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Interpreter;

public class NbtSuggestion
extends CustomSuggestion {
    public final String tag;
    public Type type;
    public Type listType = Type.UNKNOWN;
    public Subtype subtype = Subtype.NONE;
    @Nullable
    public String subtypeData = null;
    @Nullable
    public String subtypeWith = null;
    public boolean subtypeWithParentTag = false;
    @Nullable
    public NbtSuggestions subcompound = null;
    public SuggestionType suggestionType = SuggestionType.NORMAL;

    public NbtSuggestion(String tag, Type type) {
        this.tag = tag;
        this.type = type;
    }

    public NbtSuggestion(String tag, Type type, SuggestionType suggestionType) {
        this(tag, type);
        this.suggestionType = suggestionType;
    }

    public NbtSuggestion copy(boolean prediction, NbtSuggestions oldParent, NbtSuggestions newParent) {
        NbtSuggestion newSuggestion = new NbtSuggestion(this.tag, this.type, this.suggestionType);
        newSuggestion.listType = this.listType;
        newSuggestion.subtype = this.subtype;
        newSuggestion.subtypeData = this.subtypeData;
        if (prediction) {
            newSuggestion.changeSuggestionType(SuggestionType.PREDICTION);
        }
        if (this.subcompound != null) {
            if (this.subcompound == oldParent) {
                newSuggestion.subcompound = newParent;
            } else {
                newSuggestion.subcompound = new NbtSuggestions();
                newSuggestion.subcompound.copyAll(this.subcompound, prediction);
            }
        }
        return newSuggestion;
    }

    public NbtSuggestions addSubcompound() {
        this.subcompound = new NbtSuggestions();
        return this.subcompound;
    }

    public <T> boolean getSubtypeSuggestions(List<CustomSuggestion> suggestionList, ParentInfo parentInfo) {
        String finalData = this.getFinalSubtypeData(parentInfo);
        switch (this.subtype) {
            case ENUM: {
                if (finalData == null) break;
                suggestionList.clear();
                for (String substring : finalData.split(";")) {
                    suggestionList.add(new SimpleSuggestion(substring, null));
                }
                return true;
            }
            case DESCRIBED_ENUM: {
                if (finalData == null) break;
                suggestionList.clear();
                String suggestionText = null;
                for (String substring : finalData.split(";")) {
                    if (suggestionText == null) {
                        suggestionText = substring;
                        continue;
                    }
                    suggestionList.add(new SimpleSuggestion(suggestionText, String.format("  \u00a78<%s>", substring)));
                    suggestionText = null;
                }
                return true;
            }
            case REGISTRY_KEY: 
            case REGISTRY_ID: {
                if (finalData == null) break;
                try {
                    ResourceLocation registryLocation = new ResourceLocation(finalData);
                    Registry registry = (Registry)RegistryUtils.REGISTRY.m_7745_(registryLocation);
                    if (registry == null) break;
                    suggestionList.clear();
                    if (this.subtype == Subtype.REGISTRY_ID) {
                        for (Object object : registry) {
                            suggestionList.add(new SimpleSuggestion(Integer.toString(registry.m_7447_(object)), "  \u00a78\"" + registry.m_7981_(object) + "\" [#" + registryLocation.m_135815_() + "]"));
                        }
                    } else {
                        for (Object object : registry) {
                            suggestionList.add(new SimpleSuggestion("\"" + registry.m_7981_(object) + "\"", "  \u00a78[#" + registryLocation.m_135815_() + "]"));
                        }
                    }
                }
                catch (Exception registryLocation) {
                    // empty catch block
                }
                return true;
            }
            case RECIPE: {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level == null) break;
                for (ResourceLocation id : (ResourceLocation[])level.m_7465_().m_44073_().toArray(ResourceLocation[]::new)) {
                    suggestionList.add(new SimpleSuggestion("\"" + id + "\"", null));
                }
                return true;
            }
            case JSON_TEXT: {
                suggestionList.clear();
                suggestionList.add(new SimpleSuggestion("' \"", "  \u00a78[#json_text]"));
                return true;
            }
            case RANDOM_UUID: {
                suggestionList.clear();
                UUID randomUUID = UUID.randomUUID();
                int uuidInt0 = (int)randomUUID.getLeastSignificantBits();
                int uuidInt1 = (int)(randomUUID.getLeastSignificantBits() >>> 32);
                int uuidInt2 = (int)randomUUID.getMostSignificantBits();
                int uuidInt3 = (int)(randomUUID.getMostSignificantBits() >>> 32);
                String uuidString = String.format("[I;%d, %d, %d, %d]", uuidInt3, uuidInt2, uuidInt1, uuidInt0);
                suggestionList.add(new SimpleSuggestion(uuidString, "  \u00a78[#random_uuid]"));
                return true;
            }
            case INVENTORY_SLOT: {
                int i;
                suggestionList.clear();
                for (i = 0; i < 9; ++i) {
                    String subtext = String.format("  \u00a78<Hotbar %d> [#inventory_slot]", i + 1);
                    suggestionList.add(new SimpleSuggestion(Integer.toString(i), subtext));
                }
                for (i = 9; i < 35; ++i) {
                    int row = (i - 9) / 9 + 1;
                    int column = (i - 9) % 9 + 1;
                    String subtext = String.format("  \u00a78<Storage %d:%d> [#inventory_slot]", row, column);
                    suggestionList.add(new SimpleSuggestion(Integer.toString(i), subtext));
                }
                suggestionList.add(new SimpleSuggestion("100", "  \u00a78<Feet> [#inventory_slot]"));
                suggestionList.add(new SimpleSuggestion("101", "  \u00a78<Legs> [#inventory_slot]"));
                suggestionList.add(new SimpleSuggestion("102", "  \u00a78<Chest> [#inventory_slot]"));
                suggestionList.add(new SimpleSuggestion("103", "  \u00a78<Head> [#inventory_slot]"));
                suggestionList.add(new SimpleSuggestion("-106", "  \u00a78<Off-hand> [#inventory_slot]"));
                return true;
            }
        }
        return false;
    }

    public <T extends Comparable<T>> void getSubtypeTagSuggestions(List<CustomSuggestion> suggestionList, ParentInfo parentInfo) {
        String finalData = this.getFinalSubtypeData(parentInfo);
        switch (this.subtype) {
            case TAG: {
                if (finalData == null) break;
                finalData = finalData.replace("block/item/", "block/");
                finalData = finalData.replace("entity/item/", "entity/");
                NbtSuggestions tagSuggestions = NbtSuggestionManager.get(finalData);
                NbtSuggestionManager.addToList(suggestionList, tagSuggestions, finalData);
                break;
            }
            case BLOCK_STATE_TAG: {
                try {
                    if (finalData == null) break;
                    if (finalData.startsWith("block/")) {
                        finalData = finalData.substring(6);
                    } else if (finalData.startsWith("item/")) {
                        finalData = finalData.substring(5);
                    }
                    Item blockItem = RegistryUtils.ITEM.get(new ResourceLocation(finalData));
                    if (!(blockItem instanceof BlockItem)) break;
                    for (Property property : ((BlockItem)blockItem).m_40614_().m_49966_().m_61147_()) {
                        NbtSuggestion nbtSuggestion = new NbtSuggestion(property.m_61708_(), Type.STRING);
                        nbtSuggestion.subtype = Subtype.ENUM;
                        StringBuilder enumStringBuilder = new StringBuilder();
                        for (Comparable possibleValue : property.m_6908_()) {
                            enumStringBuilder.append("\"").append(property.m_6940_(possibleValue)).append("\";");
                        }
                        nbtSuggestion.subtypeData = enumStringBuilder.toString();
                        suggestionList.add(nbtSuggestion);
                    }
                    break;
                }
                catch (Exception blockItem) {
                    break;
                }
            }
            case SPAWN_EGG: {
                try {
                    Item item;
                    if (finalData == null) break;
                    if (finalData.startsWith("item/")) {
                        finalData = finalData.substring(5);
                    }
                    if (!((item = RegistryUtils.ITEM.get(new ResourceLocation(finalData))) instanceof SpawnEggItem)) break;
                    String key = RegistryUtils.ENTITY_TYPE.getKey(((SpawnEggItem)item).m_43228_(null)).toString();
                    NbtSuggestions spawnEggSuggestions = NbtSuggestionManager.get("entity/" + key);
                    NbtSuggestionManager.addToList(suggestionList, spawnEggSuggestions, finalData);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String getFinalTagName(ParentInfo parentInfo) {
        String finalData = this.getFinalSubtypeData(parentInfo);
        if (this.subtype == Subtype.TAG && finalData != null) {
            return finalData.replace("block/item/", "block/");
        }
        return this.tag;
    }

    @Nullable
    private String getFinalSubtypeData(ParentInfo parentInfo) {
        if (this.subtypeWith != null && this.subtypeData != null && this.subtypeData.contains("*")) {
            Map<String, String> map;
            if (this.subtypeWith.equals("#parent")) {
                if (parentInfo.parentTag == null) {
                    return null;
                }
                return this.subtypeData.replace("*", parentInfo.parentTag);
            }
            if (this.subtypeWith.equals("#parent2")) {
                if (parentInfo.secondParentTag == null) {
                    return null;
                }
                return this.subtypeData.replace("*", parentInfo.secondParentTag);
            }
            Map<String, String> map2 = map = this.subtypeWithParentTag ? parentInfo.parentTagMap : parentInfo.tagMap;
            if (map == null) {
                return null;
            }
            String tagValue = map.get(this.subtypeWith);
            if (tagValue == null) {
                return null;
            }
            return this.subtypeData.replace("*", tagValue);
        }
        return this.subtypeData;
    }

    public void changeSuggestionType(SuggestionType newSuggestionType) {
        if (newSuggestionType.level >= this.suggestionType.level) {
            this.suggestionType = newSuggestionType;
        }
    }

    @Override
    public String getSuggestionText() {
        return this.tag;
    }

    @Override
    public String getSuggestionSubtext() {
        return String.format("  \u00a78%s[%s]", this.suggestionType.symbol, this.type.getName());
    }

    @Override
    public Message getSuggestionTooltip() {
        return new ComparableLiteralMessage(String.format("%s\u00a7r \u00a78%s[%s]", this.tag, this.suggestionType.name, this.type.getName()));
    }

    public static enum Type {
        NOT_FOUND(-1),
        UNKNOWN(-1),
        BOOLEAN(-1),
        BYTE(1),
        SHORT(2),
        INT(3),
        LONG(4),
        FLOAT(5),
        DOUBLE(6),
        STRING(8),
        LIST(9),
        BYTE_ARRAY(7),
        INT_ARRAY(11),
        LONG_ARRAY(12),
        COMPOUND(10),
        UUID(-1);

        private static final HashMap<String, Type> nameMap;
        private static final HashMap<String, Type> methodNameMap;
        private static final HashMap<Byte, Type> idMap;
        private final byte id;

        private Type(byte id) {
            this.id = id;
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public static void init() {
            for (Type type : Type.values()) {
                String typeName = type.getName();
                nameMap.put(typeName, type);
                idMap.put(type.id, type);
            }
            try {
                ClassNode classNode = Disassembly.loadClass(CompoundTag.class.getCanonicalName());
                for (MethodNode method : classNode.methods) {
                    Type type;
                    if ((method.access & 1) == 0 || (type = Type.fromMethodObject(classNode, method)) == NOT_FOUND) continue;
                    methodNameMap.put(method.name, type);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static Type fromName(String name) {
            return nameMap.getOrDefault(name, NOT_FOUND);
        }

        public static Type fromMethodName(String name) {
            return methodNameMap.getOrDefault(name, NOT_FOUND);
        }

        public static Type fromID(byte id) {
            return idMap.getOrDefault(id, UNKNOWN);
        }

        private static Type fromMethodObject(ClassNode classNode, MethodNode method) {
            String signature = method.desc;
            String methodArguments = "(Ljava/lang/String;)";
            if (!signature.startsWith(methodArguments)) {
                String getListSignature = "(Ljava/lang/String;I)L" + ListTag.class.getName().replace('.', '/') + ";";
                if (method.desc.equals(getListSignature)) {
                    return LIST;
                }
                return NOT_FOUND;
            }
            String retTypeSignature = signature.substring(signature.indexOf(41) + 1);
            if (retTypeSignature.equals("L" + Tag.class.getName().replace('.', '/') + ";")) {
                return UNKNOWN;
            }
            if (retTypeSignature.equals("L" + CompoundTag.class.getName().replace('.', '/') + ";")) {
                return COMPOUND;
            }
            switch (retTypeSignature) {
                case "S": {
                    return SHORT;
                }
                case "I": {
                    return INT;
                }
                case "J": {
                    return LONG;
                }
                case "F": {
                    return FLOAT;
                }
                case "D": {
                    return DOUBLE;
                }
                case "[B": {
                    return BYTE_ARRAY;
                }
                case "[I": {
                    return INT_ARRAY;
                }
                case "[J": {
                    return LONG_ARRAY;
                }
                case "Ljava/lang/String;": {
                    return STRING;
                }
                case "Ljava/util/UUID;": {
                    return UUID;
                }
                case "B": 
                case "Z": {
                    break;
                }
                default: {
                    return NOT_FOUND;
                }
            }
            try {
                Disassembly.ValueTracker valueTracker = new Disassembly.ValueTracker(null, false, true);
                Analyzer analyzer = new Analyzer((Interpreter)valueTracker);
                analyzer.analyze(classNode.name, method);
                for (Disassembly.InvokeInfo invokeInfo : valueTracker.invokes) {
                    if (invokeInfo.insn.desc.equals("(Ljava/lang/String;I)Z")) {
                        return BYTE;
                    }
                    if (!invokeInfo.insn.desc.equals("(Ljava/lang/String;)B")) continue;
                    return BOOLEAN;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return NOT_FOUND;
        }

        static {
            nameMap = new HashMap();
            methodNameMap = new HashMap();
            idMap = new HashMap();
        }
    }

    public static enum Subtype {
        NONE,
        ENUM,
        DESCRIBED_ENUM,
        TAG,
        BLOCK_STATE_TAG,
        SPAWN_EGG,
        REGISTRY_ID,
        REGISTRY_KEY,
        RECIPE,
        ITEM_COMPOUND,
        JSON_TEXT,
        RANDOM_UUID,
        INVENTORY_SLOT;


        public String getName() {
            return this.name().toLowerCase();
        }

        public static Subtype fromName(String name) {
            for (Subtype subtype : Subtype.values()) {
                if (!name.equals(subtype.getName())) continue;
                return subtype;
            }
            return NONE;
        }
    }

    public static enum SuggestionType {
        NORMAL("", "", 0),
        UNCERTAIN("(?) ", "(uncertain) ", 1),
        COMPOUND_PREDICTION("(C) ", "(compound prediction) ", 2),
        SUBTYPE_PREDICTION("(S) ", "(subtype prediction) ", 3),
        TYPE_PREDICTION("(T) ", "(type prediction) ", 4),
        PREDICTION("(*) ", "(prediction) ", 5);

        public final String symbol;
        public final String name;
        public final int level;

        private SuggestionType(String symbol, String name, int level) {
            this.symbol = symbol;
            this.name = name;
            this.level = level;
        }
    }

    public static class ParentInfo {
        @Nullable
        public Map<String, String> tagMap;
        @Nullable
        public Map<String, String> parentTagMap;
        @Nullable
        public String parentTag;
        @Nullable
        public String secondParentTag;

        private ParentInfo(@Nullable Map<String, String> tagMap, @Nullable Map<String, String> parentTagMap, @Nullable String parentTag, @Nullable String secondParentTag) {
            this.tagMap = tagMap;
            this.parentTagMap = parentTagMap;
            this.parentTag = parentTag;
            this.secondParentTag = secondParentTag;
        }

        public ParentInfo withTagMap(@Nullable Map<String, String> newTagMap) {
            return new ParentInfo(newTagMap, this.parentTagMap, this.parentTag, this.secondParentTag);
        }

        public ParentInfo createChild(@Nullable NbtSuggestion suggestion) {
            if (suggestion == null) {
                return new ParentInfo(new HashMap<String, String>(), this.tagMap, "[undefined]", this.parentTag);
            }
            ParentInfo newParentInfo = new ParentInfo(new HashMap<String, String>(), this.tagMap, suggestion.tag, this.parentTag);
            newParentInfo.parentTag = suggestion.getFinalTagName(newParentInfo);
            return newParentInfo;
        }

        public void putTag(String key, String value) {
            if (this.tagMap != null) {
                this.tagMap.put(key, value);
            }
        }

        public static ParentInfo fromRoot(@Nullable String rootTag) {
            return new ParentInfo(new HashMap<String, String>(), null, rootTag, null);
        }

        public static ParentInfo blank() {
            return new ParentInfo(new HashMap<String, String>(), null, null, null);
        }
    }
}

