/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.resourceloader;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mt1006.nbt_ac.NBTac;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ResourceLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final String RESOURCE_DIRECTORY = "nbt_ac_suggestions";
    public static final List<Pair<String, JsonObject>> common = new ArrayList<Pair<String, JsonObject>>();
    public static final List<Pair<String, JsonObject>> tags = new ArrayList<Pair<String, JsonObject>>();
    public static final List<Pair<JsonArray, JsonArray>> predictions = new ArrayList<Pair<JsonArray, JsonArray>>();
    public static boolean firstCall = true;
    public static CountDownLatch countDownLatch = new CountDownLatch(1);

    @NotNull
    protected Map<ResourceLocation, JsonElement> prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        Gson gson = new Gson();
        HashMap map = Maps.newHashMap();
        FileToIdConverter fileToIdConverter = FileToIdConverter.m_246568_((String)RESOURCE_DIRECTORY);
        for (Map.Entry entry : fileToIdConverter.m_247457_(resourceManager).entrySet()) {
            ResourceLocation resourceLocation = fileToIdConverter.m_245273_((ResourceLocation)entry.getKey());
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)gson, (Reader)reader, JsonElement.class);
                    map.put(resourceLocation, jsonElement);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {}
        }
        return map;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resources, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        if (!firstCall) {
            return;
        }
        firstCall = false;
        for (Map.Entry<ResourceLocation, JsonElement> resourceEntry : resources.entrySet()) {
            try {
                JsonObject json = resourceEntry.getValue().getAsJsonObject();
                MutablePair predictionPair = new MutablePair(null, null);
                for (Map.Entry entry : json.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    if (key.equals("conditions")) {
                        predictionPair.left = value.getAsJsonArray();
                        continue;
                    }
                    if (key.equals("operations")) {
                        predictionPair.right = value.getAsJsonArray();
                        continue;
                    }
                    if (key.startsWith("common/")) {
                        common.add((Pair<String, JsonObject>)new ImmutablePair((Object)key, (Object)value.getAsJsonObject()));
                        continue;
                    }
                    if (key.startsWith("tag/")) {
                        tags.add((Pair<String, JsonObject>)new ImmutablePair((Object)key, (Object)value.getAsJsonObject()));
                        continue;
                    }
                    if (!key.startsWith("parent/")) continue;
                    tags.add((Pair<String, JsonObject>)new ImmutablePair(null, (Object)value.getAsJsonObject()));
                }
                if (predictionPair.left == null || predictionPair.right == null) continue;
                predictions.add((Pair<JsonArray, JsonArray>)predictionPair);
            }
            catch (Exception exception) {
                NBTac.LOGGER.warn("Failed to load resource: " + resourceEntry.getKey().toString());
            }
        }
        countDownLatch.countDown();
    }
}

