/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.resourceloader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class Prediction {
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final List<Operation> operations = new ArrayList<Operation>();

    public Prediction(Pair<JsonArray, JsonArray> prediction) {
        ((JsonArray)prediction.getLeft()).forEach(element -> this.conditions.add(new Condition(element.getAsJsonObject())));
        ((JsonArray)prediction.getRight()).forEach(element -> this.operations.add(new Operation(element.getAsJsonObject())));
    }

    public void execute() {
        for (Condition condition : this.conditions) {
            for (NbtSuggestion suggestion : condition.matchingSuggestions()) {
                this.operations.forEach(operation -> operation.execute(suggestion));
            }
        }
    }

    private static class Condition {
        @Nullable
        private final String root;
        @Nullable
        private final String path;

        public Condition(JsonObject object) {
            JsonElement rootElement = object.get("root");
            this.root = rootElement != null ? rootElement.getAsString() : null;
            JsonElement pathElement = object.get("path");
            this.path = pathElement != null ? pathElement.getAsJsonArray().get(0).getAsString() : null;
        }

        public Collection<NbtSuggestion> matchingSuggestions() {
            if (this.path != null) {
                if (this.path.startsWith("*")) {
                    String key = this.path.substring(1);
                    return (this.root != null ? NbtSuggestionManager.get((String)this.root).suffixMap : NbtSuggestions.suffixFullMap).get((Object)key);
                }
                if (this.path.endsWith("*")) {
                    String key = this.path.substring(0, this.path.length() - 1);
                    return (this.root != null ? NbtSuggestionManager.get((String)this.root).prefixMap : NbtSuggestions.prefixFullMap).get((Object)key);
                }
                return this.root != null ? List.of(NbtSuggestionManager.get(this.root).get(this.path)) : NbtSuggestions.fullMap.get((Object)this.path);
            }
            if (this.root != null) {
                NbtSuggestion dummySuggestion = new NbtSuggestion("dummy-" + this.root, NbtSuggestion.Type.COMPOUND);
                dummySuggestion.subcompound = NbtSuggestionManager.get(this.root);
                return List.of(dummySuggestion);
            }
            return new ArrayList<NbtSuggestion>();
        }
    }

    private static class Operation {
        @Nullable
        public final String on;
        @Nullable
        public final String with;
        public final String type;
        public final String val;

        public Operation(JsonObject object) {
            JsonElement onElement = object.get("on");
            this.on = onElement != null ? onElement.getAsString() : null;
            JsonElement withElement = object.get("with");
            this.with = withElement != null ? withElement.getAsString() : null;
            JsonElement typeElement = object.get("type");
            this.type = typeElement != null ? typeElement.getAsString() : "";
            JsonElement valElement = object.get("val");
            this.val = valElement != null ? valElement.getAsString() : "";
        }

        public void execute(NbtSuggestion suggestion) {
            if (this.on == null) {
                this.executeOn(suggestion, null);
            } else if (suggestion.subcompound != null) {
                this.executeOn(suggestion.subcompound.get(this.on), suggestion.subcompound);
            }
        }

        private void executeOn(@Nullable NbtSuggestion suggestion, @Nullable NbtSuggestions root) {
            if (suggestion == null) {
                return;
            }
            switch (this.type) {
                case "set_type": {
                    suggestion.type = NbtSuggestion.Type.fromName(this.val);
                    suggestion.changeSuggestionType(NbtSuggestion.SuggestionType.TYPE_PREDICTION);
                    return;
                }
                case "set_subtype": {
                    int slashPos = this.val.indexOf(47);
                    suggestion.subtype = NbtSuggestion.Subtype.fromName(slashPos != -1 ? this.val.substring(0, slashPos) : this.val);
                    if (slashPos != -1) {
                        suggestion.subtypeData = this.val.substring(slashPos + 1);
                    }
                    suggestion.subtypeWith = this.with;
                    suggestion.subtypeWithParentTag = this.on != null;
                    suggestion.changeSuggestionType(NbtSuggestion.SuggestionType.SUBTYPE_PREDICTION);
                    return;
                }
                case "set_subcompound": {
                    suggestion.subcompound = NbtSuggestionManager.get(this.val);
                    suggestion.changeSuggestionType(NbtSuggestion.SuggestionType.COMPOUND_PREDICTION);
                    return;
                }
            }
            if (suggestion.subcompound == null) {
                if (suggestion.type == NbtSuggestion.Type.COMPOUND || suggestion.listType == NbtSuggestion.Type.COMPOUND) {
                    suggestion.subcompound = new NbtSuggestions();
                } else {
                    return;
                }
            }
            NbtSuggestions compound = suggestion.subcompound;
            switch (this.type) {
                case "recursion": {
                    if (root == null) {
                        return;
                    }
                    suggestion.subcompound = root;
                    suggestion.changeSuggestionType(NbtSuggestion.SuggestionType.COMPOUND_PREDICTION);
                    return;
                }
                case "add_tag": {
                    int thirdSlash;
                    int firstSlash = this.val.indexOf(47);
                    int secondSlash = firstSlash != -1 ? this.val.indexOf(47, firstSlash + 1) : -1;
                    int n = thirdSlash = secondSlash != -1 ? this.val.indexOf(47, secondSlash + 1) : -1;
                    if (firstSlash == -1) {
                        return;
                    }
                    String tagStr = this.val.substring(0, firstSlash);
                    String typeStr = secondSlash != -1 ? this.val.substring(firstSlash + 1, secondSlash) : this.val.substring(firstSlash + 1);
                    NbtSuggestion.Type type = NbtSuggestion.Type.fromName(typeStr);
                    NbtSuggestion newSuggestion = new NbtSuggestion(tagStr, type, NbtSuggestion.SuggestionType.PREDICTION);
                    if (secondSlash != -1) {
                        String subtypeStr = thirdSlash != -1 ? this.val.substring(secondSlash + 1, thirdSlash) : this.val.substring(secondSlash + 1);
                        String subtypeDataStr = thirdSlash != -1 ? this.val.substring(thirdSlash + 1) : null;
                        newSuggestion.subtype = NbtSuggestion.Subtype.fromName(subtypeStr);
                        newSuggestion.subtypeData = subtypeDataStr;
                    }
                    compound.add(newSuggestion);
                    return;
                }
                case "copy_tags": {
                    compound.copyAll(NbtSuggestionManager.get(this.val), true);
                    return;
                }
            }
            NBTac.LOGGER.warn("Unknown prediction type: " + this.type);
        }
    }
}

