/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader;

import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.loader.resourceloader.ParseJson;
import com.mt1006.nbt_ac.autocomplete.loader.resourceloader.ResourceLoader;
import com.mt1006.nbt_ac.autocomplete.loader.typeloader.Disassembly;
import com.mt1006.nbt_ac.autocomplete.loader.typeloader.TypeLoader;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;

public class Loader {
    private static final String SAVE_SUGGESTIONS_FILE = "nbt_ac_output.txt";
    private static final int MAX_PRINTER_DEPTH = 32;
    private static volatile Thread thread;
    public static AtomicBoolean finished;

    public static void load() {
        long start = System.currentTimeMillis();
        thread = Thread.currentThread();
        if (ModConfig.useDisassembler.getValue().booleanValue()) {
            Disassembly.init();
            TypeLoader.loadBlockEntityTypes();
            TypeLoader.loadEntityTypes();
            Disassembly.clear();
        }
        long interruptionStart = System.currentTimeMillis();
        try {
            ResourceLoader.countDownLatch.await();
        }
        catch (InterruptedException exception) {
            NBTac.LOGGER.warn("Unexpected \"ResourceLoader.countDownLatch.await()\" interruption");
        }
        long interruptionDuration = System.currentTimeMillis() - interruptionStart;
        if (ModConfig.loadFromResources.getValue().booleanValue()) {
            ParseJson.parseAll();
        }
        long duration = System.currentTimeMillis() - start;
        NBTac.LOGGER.info("Finished in: " + (duration - interruptionDuration) + " ms [" + duration + " ms with interruption]");
        finished.set(true);
        Loader.saveSuggestions(ModConfig.saveSuggestions.getValue());
    }

    public static void saveSuggestions(int mode) {
        if (mode == 1 || mode == 2) {
            File outputFile = new File(Minecraft.m_91087_().f_91069_, SAVE_SUGGESTIONS_FILE);
            try (PrintWriter fileWriter = new PrintWriter(new FileWriter(outputFile));){
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                for (Map.Entry<String, NbtSuggestions> suggestions : NbtSuggestionManager.suggestionMap.entrySet()) {
                    writer.println(suggestions.getKey());
                    Loader.printSuggestions(writer, suggestions.getKey(), suggestions.getValue(), mode, 1);
                    writer.println("");
                }
                if (mode == 2) {
                    Object[] strings = stringWriter.toString().split(System.lineSeparator());
                    Arrays.sort(strings);
                    for (Object str : strings) {
                        fileWriter.write((String)str);
                    }
                } else {
                    fileWriter.write(stringWriter.toString());
                }
            }
            catch (Exception exception) {
                NBTac.LOGGER.warn("Failed to save suggestions!");
            }
        }
    }

    public static void printSuggestions(PrintWriter writer, String key, NbtSuggestions suggestions, int mode, int depth) {
        if (depth > 32) {
            return;
        }
        for (NbtSuggestion suggestion : suggestions.getAll()) {
            if (mode == 2) {
                writer.print(key);
            }
            for (int i = 0; i < depth; ++i) {
                writer.print("-");
            }
            writer.printf("%s (%s) [%s/%s] - %s/%s\n", suggestion.tag, suggestion.suggestionType.name, suggestion.type.getName(), suggestion.listType.getName(), suggestion.subtype.getName(), suggestion.subtypeData);
            if (suggestion.subcompound == null || suggestions == suggestion.subcompound) continue;
            Loader.printSuggestions(writer, key, suggestion.subcompound, mode, depth + 1);
        }
    }

    public static void printStackTrace(Exception exception) {
        if (ModConfig.printExceptionStackTrace.getValue().booleanValue()) {
            exception.printStackTrace();
        }
    }

    public static boolean isCurrentThread() {
        return Thread.currentThread() == thread;
    }

    static {
        finished = new AtomicBoolean(false);
    }
}

