/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.suggestions.CustomSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.TagParser;
import org.jetbrains.annotations.Nullable;

public class CustomTagParser {
    public final StringReader reader;
    public NbtSuggestion lastFoundSuggestion = null;

    public CustomTagParser(String tag) {
        this.reader = new StringReader(tag);
    }

    public Suggestion read(List<CustomSuggestion> suggestionList, @Nullable NbtSuggestion suggestion, @Nullable String parentTag, boolean suggestPath) {
        try {
            if (suggestPath) {
                return this.readPath(suggestionList);
            }
            return this.readStruct(suggestionList, suggestion, NbtSuggestion.ParentInfo.fromRoot(parentTag), false);
        }
        catch (CommandSyntaxException ignore) {
            return Suggestion.NONE;
        }
    }

    private Suggestion readPath(List<CustomSuggestion> suggestionList) {
        try {
            while (true) {
                Suggestion compoundSuggestion;
                NbtSuggestion foundSuggestion;
                String key;
                if ((key = this.readPathKey()).isEmpty()) {
                    return Suggestion.TAG;
                }
                ArrayList<CustomSuggestion> potentialSuggestions = new ArrayList<CustomSuggestion>();
                this.lastFoundSuggestion = foundSuggestion = this.findSuggestion(suggestionList, key, potentialSuggestions);
                if (!this.reader.canRead()) {
                    suggestionList.clear();
                    suggestionList.addAll(potentialSuggestions);
                    this.reader.setCursor(this.reader.getCursor() - key.length());
                    return Suggestion.TAG;
                }
                if (foundSuggestion == null) {
                    return Suggestion.NONE;
                }
                if (this.reader.peek() == '[') {
                    this.expect('[');
                    if (!this.reader.canRead()) {
                        return Suggestion.NONE;
                    }
                    if (this.reader.peek() == '{') {
                        compoundSuggestion = this.readSubcompound(foundSuggestion, suggestionList, NbtSuggestion.ParentInfo.blank());
                        if (compoundSuggestion != Suggestion.CONTINUE) {
                            return compoundSuggestion;
                        }
                    } else {
                        this.readPathKey();
                    }
                    this.expect(']');
                }
                if (!this.reader.canRead()) {
                    return Suggestion.NONE;
                }
                if (this.reader.peek() == '{' && (compoundSuggestion = this.readSubcompound(foundSuggestion, suggestionList, NbtSuggestion.ParentInfo.blank())) != Suggestion.CONTINUE) {
                    return compoundSuggestion;
                }
                if (!this.reader.canRead()) {
                    return Suggestion.NONE;
                }
                this.expect('.');
                suggestionList.clear();
                if (foundSuggestion.subcompound == null) continue;
                suggestionList.addAll(foundSuggestion.subcompound.getAll());
            }
        }
        catch (CommandSyntaxException ignore) {
            return Suggestion.NONE;
        }
    }

    private Suggestion readStruct(List<CustomSuggestion> suggestionList, @Nullable NbtSuggestion suggestion, NbtSuggestion.ParentInfo parentInfo, boolean isMapScanner) throws CommandSyntaxException {
        if (suggestion != null) {
            if (!isMapScanner) {
                ArrayList<CustomSuggestion> tempSuggestionList = new ArrayList<CustomSuggestion>();
                HashMap<String, String> tempTagMap = new HashMap<String, String>();
                NbtSuggestion.ParentInfo tempParentInfo = parentInfo.withTagMap(tempTagMap);
                if (suggestion.subcompound != null) {
                    tempSuggestionList.addAll(suggestion.subcompound.getAll());
                }
                suggestion.getSubtypeTagSuggestions(tempSuggestionList, tempParentInfo);
                int oldPos = this.reader.getCursor();
                try {
                    this.readStruct(tempSuggestionList, suggestion, tempParentInfo, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                suggestion.getSubtypeTagSuggestions(suggestionList, tempParentInfo);
                this.reader.setCursor(oldPos);
            } else {
                suggestion.getSubtypeTagSuggestions(suggestionList, parentInfo);
            }
        }
        if (!this.reader.canRead()) {
            return Suggestion.COMPOUND_BEGIN;
        }
        this.expect('{');
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == '}') {
            this.expect('}');
            return Suggestion.CONTINUE;
        }
        do {
            String key;
            if ((key = this.readKey()).isEmpty()) {
                return Suggestion.TAG;
            }
            parentInfo.putTag(key, null);
            ArrayList<CustomSuggestion> potentialSuggestions = new ArrayList<CustomSuggestion>();
            NbtSuggestion foundSuggestion = this.findSuggestion(suggestionList, key, potentialSuggestions);
            if (!this.reader.canRead()) {
                if (foundSuggestion == null) {
                    suggestionList.clear();
                    suggestionList.addAll(potentialSuggestions);
                    this.reader.setCursor(this.reader.getCursor() - key.length());
                    return Suggestion.TAG;
                }
                return Suggestion.COLON;
            }
            if (foundSuggestion != null) {
                suggestionList.remove(foundSuggestion);
            }
            this.expect(':');
            Suggestion suggestionForValue = this.readValue(foundSuggestion, suggestionList, parentInfo, false);
            if (suggestionForValue == Suggestion.CONTINUE) continue;
            return suggestionForValue;
        } while (this.hasElementSeparator());
        this.reader.skipWhitespace();
        if (this.reader.canRead()) {
            this.expect('}');
            return Suggestion.CONTINUE;
        }
        if (suggestionList.isEmpty()) {
            return Suggestion.COMPOUND_END;
        }
        return Suggestion.COMMA_OR_COMPOUND_END;
    }

    private String readKey() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        return this.reader.readString();
    }

    private String readPathKey() {
        this.reader.skipWhitespace();
        int start = this.reader.getCursor();
        while (this.reader.canRead() && StringReader.isAllowedInUnquotedString((char)this.reader.peek()) && this.reader.peek() != '.') {
            this.reader.skip();
        }
        return this.reader.getString().substring(start, this.reader.getCursor());
    }

    private Suggestion readValue(@Nullable NbtSuggestion suggestion, List<CustomSuggestion> suggestionList, NbtSuggestion.ParentInfo parentInfo, boolean fromList) throws CommandSyntaxException {
        char peek;
        this.reader.skipWhitespace();
        char c = peek = this.reader.canRead() ? this.reader.peek() : (char)'\u0000';
        if (peek == '{') {
            return this.readSubcompound(suggestion, suggestionList, parentInfo);
        }
        if (peek == '[') {
            return this.readList(suggestion, suggestionList, parentInfo);
        }
        return this.readTypedValue(suggestion, suggestionList, parentInfo, fromList);
    }

    private Suggestion readTypedValue(@Nullable NbtSuggestion suggestion, List<CustomSuggestion> suggestionList, NbtSuggestion.ParentInfo parentInfo, boolean fromList) {
        NbtSuggestion.Type expectedType = NbtSuggestion.Type.UNKNOWN;
        if (suggestion != null) {
            expectedType = fromList ? suggestion.listType : suggestion.type;
        }
        this.reader.skipWhitespace();
        int cursor = this.reader.getCursor();
        boolean readStringError = false;
        if (this.reader.canRead()) {
            if (StringReader.isQuotedStringStart((char)this.reader.peek())) {
                try {
                    if (suggestion != null) {
                        parentInfo.putTag(suggestion.tag, this.reader.readQuotedString());
                    }
                }
                catch (Exception exception) {
                    readStringError = true;
                }
            } else {
                this.reader.readUnquotedString();
            }
        }
        if (!this.reader.canRead() || readStringError) {
            this.reader.setCursor(cursor);
            if (suggestion != null && expectedType != NbtSuggestion.Type.LIST && suggestion.getSubtypeSuggestions(suggestionList, parentInfo)) {
                String prefix = this.reader.getString().substring(cursor);
                suggestionList.removeIf(customSuggestion -> !customSuggestion.getSuggestionText().startsWith(prefix) && !customSuggestion.getSuggestionText().startsWith("\"minecraft:" + prefix) && (!prefix.startsWith("\"") || !customSuggestion.getSuggestionText().startsWith("\"minecraft:" + prefix.substring(1))));
                return Suggestion.TAG;
            }
            return Suggestion.fromNbtType(expectedType);
        }
        return Suggestion.CONTINUE;
    }

    private Suggestion readList(@Nullable NbtSuggestion suggestion, List<CustomSuggestion> suggestionList, NbtSuggestion.ParentInfo parentInfo) throws CommandSyntaxException {
        if (this.reader.canRead(3) && !StringReader.isQuotedStringStart((char)this.reader.peek(1)) && this.reader.peek(2) == ';') {
            this.readArrayTag();
            if (this.reader.canRead()) {
                return Suggestion.CONTINUE;
            }
            return Suggestion.NONE;
        }
        return this.readListTag(suggestion, suggestionList, parentInfo);
    }

    private Suggestion readListTag(NbtSuggestion suggestion, List<CustomSuggestion> suggestionList, NbtSuggestion.ParentInfo parentInfo) throws CommandSyntaxException {
        this.expect('[');
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == ']') {
            this.expect(']');
            return Suggestion.CONTINUE;
        }
        do {
            Suggestion valueSuggestion;
            if ((valueSuggestion = this.readValue(suggestion, suggestionList, parentInfo, true)) == Suggestion.CONTINUE) continue;
            return valueSuggestion;
        } while (this.hasElementSeparator());
        if (this.reader.canRead()) {
            this.expect(']');
            return Suggestion.CONTINUE;
        }
        return Suggestion.COMMA_OR_LIST_END;
    }

    private void readArrayTag() throws CommandSyntaxException {
        this.expect('[');
        char key = this.reader.read();
        this.reader.read();
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw TagParser.f_129335_.createWithContext((ImmutableStringReader)this.reader);
        }
        if (key != 'B' && key != 'L' && key != 'I') {
            throw TagParser.f_129335_.createWithContext((ImmutableStringReader)this.reader);
        }
        this.readArray();
    }

    private void readArray() throws CommandSyntaxException {
        while (this.reader.peek() != ']') {
            this.readValue(null, null, NbtSuggestion.ParentInfo.blank(), false);
            if (!this.hasElementSeparator()) break;
            if (this.reader.canRead()) continue;
            throw TagParser.f_129336_.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect(']');
    }

    private Suggestion readSubcompound(@Nullable NbtSuggestion suggestion, List<CustomSuggestion> suggestionList, NbtSuggestion.ParentInfo parentInfo) throws CommandSyntaxException {
        Suggestion substructSuggestion;
        ArrayList<CustomSuggestion> newSuggestionList = new ArrayList<CustomSuggestion>();
        if (suggestion != null && suggestion.subcompound != null) {
            newSuggestionList.addAll(suggestion.subcompound.getAll());
        }
        if ((substructSuggestion = this.readStruct(newSuggestionList, suggestion, parentInfo.createChild(suggestion), false)) == Suggestion.TAG && suggestionList != null) {
            suggestionList.clear();
            suggestionList.addAll(newSuggestionList);
        }
        return substructSuggestion;
    }

    private NbtSuggestion findSuggestion(List<CustomSuggestion> suggestionList, String key, List<CustomSuggestion> potentialSuggestions) {
        NbtSuggestion foundSuggestion = null;
        for (CustomSuggestion customSuggestion : suggestionList) {
            if (customSuggestion instanceof NbtSuggestion) {
                NbtSuggestion suggestion = (NbtSuggestion)customSuggestion;
                if (ModConfig.ignoreLetterCase.getValue() == false ? !suggestion.tag.startsWith(key) : !suggestion.tag.toLowerCase().startsWith(key.toLowerCase())) continue;
                if (suggestion.tag.equals(key)) {
                    foundSuggestion = suggestion;
                }
                potentialSuggestions.add(suggestion);
                continue;
            }
            potentialSuggestions.add(customSuggestion);
        }
        return foundSuggestion;
    }

    private boolean hasElementSeparator() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == ',') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }

    private void expect(char p_129353_) throws CommandSyntaxException {
        this.reader.skipWhitespace();
        this.reader.expect(p_129353_);
    }

    public static enum Suggestion {
        TAG,
        COLON,
        COMPOUND_BEGIN,
        COMPOUND_END,
        COMMA_OR_COMPOUND_END,
        LIST_BEGIN,
        COMMA_OR_LIST_END,
        BOOLEAN,
        STRING,
        BYTE_ARRAY,
        INT_ARRAY,
        LONG_ARRAY,
        TYPE_BYTE,
        TYPE_SHORT,
        TYPE_INT,
        TYPE_LONG,
        TYPE_FLOAT,
        TYPE_DOUBLE,
        NONE,
        CONTINUE;


        public void suggest(SuggestionsBuilder suggestionsBuilder) {
            String typeString = this.getType();
            if (typeString != null) {
                typeString = String.format("\u00a78[%s]", typeString);
            }
            for (String suggestion : this.getSuggestions()) {
                if (!suggestion.startsWith(suggestionsBuilder.getRemaining())) continue;
                Object type = null;
                if (typeString != null) {
                    type = suggestion.isEmpty() ? typeString : " " + typeString;
                }
                NbtSuggestionManager.simpleSuggestion(suggestion, type, suggestionsBuilder);
            }
        }

        private String[] getSuggestions() {
            switch (this) {
                case COLON: {
                    return new String[]{":"};
                }
                case COMPOUND_BEGIN: {
                    return new String[]{"{"};
                }
                case COMPOUND_END: {
                    return new String[]{"}"};
                }
                case COMMA_OR_COMPOUND_END: {
                    return new String[]{",", "}"};
                }
                case LIST_BEGIN: {
                    return new String[]{"["};
                }
                case COMMA_OR_LIST_END: {
                    return new String[]{",", "]"};
                }
                case STRING: {
                    return new String[]{"\""};
                }
                case BYTE_ARRAY: {
                    return new String[]{"[B;"};
                }
                case INT_ARRAY: {
                    return new String[]{"[I;"};
                }
                case LONG_ARRAY: {
                    return new String[]{"[L;"};
                }
                case BOOLEAN: {
                    if (ModConfig.shortBoolean.getValue().booleanValue()) {
                        return new String[]{"1b", "0b"};
                    }
                    return new String[]{"true", "false"};
                }
                case TYPE_BYTE: 
                case TYPE_SHORT: 
                case TYPE_INT: 
                case TYPE_LONG: 
                case TYPE_FLOAT: 
                case TYPE_DOUBLE: {
                    return new String[]{""};
                }
            }
            return new String[0];
        }

        private String getType() {
            switch (this) {
                case TYPE_BYTE: {
                    return NbtSuggestion.Type.BYTE.getName();
                }
                case TYPE_SHORT: {
                    return NbtSuggestion.Type.SHORT.getName();
                }
                case TYPE_INT: {
                    return NbtSuggestion.Type.INT.getName();
                }
                case TYPE_LONG: {
                    return NbtSuggestion.Type.LONG.getName();
                }
                case TYPE_FLOAT: {
                    return NbtSuggestion.Type.FLOAT.getName();
                }
                case TYPE_DOUBLE: {
                    return NbtSuggestion.Type.DOUBLE.getName();
                }
                case BOOLEAN: {
                    return NbtSuggestion.Type.BOOLEAN.getName();
                }
                case STRING: {
                    return NbtSuggestion.Type.STRING.getName();
                }
                case BYTE_ARRAY: {
                    return NbtSuggestion.Type.BYTE_ARRAY.getName();
                }
                case INT_ARRAY: {
                    return NbtSuggestion.Type.INT_ARRAY.getName();
                }
                case LONG_ARRAY: {
                    return NbtSuggestion.Type.LONG_ARRAY.getName();
                }
            }
            return null;
        }

        public static Suggestion fromNbtType(NbtSuggestion.Type type) {
            switch (type) {
                case STRING: {
                    return STRING;
                }
                case COMPOUND: {
                    return COMPOUND_BEGIN;
                }
                case LIST: {
                    return LIST_BEGIN;
                }
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case BYTE_ARRAY: {
                    return BYTE_ARRAY;
                }
                case LONG_ARRAY: {
                    return LONG_ARRAY;
                }
                case BYTE: {
                    return TYPE_BYTE;
                }
                case SHORT: {
                    return TYPE_SHORT;
                }
                case INT: {
                    return TYPE_INT;
                }
                case LONG: {
                    return TYPE_LONG;
                }
                case FLOAT: {
                    return TYPE_FLOAT;
                }
                case DOUBLE: {
                    return TYPE_DOUBLE;
                }
                case INT_ARRAY: 
                case UUID: {
                    return INT_ARRAY;
                }
            }
            return NONE;
        }
    }
}

