/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.util;

import com.unrealdinnerbone.jamd.JAMDRegistry;
import com.unrealdinnerbone.trenzalore.api.platform.Services;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class TelerportUtils {
    public static void teleport(Player playerEntity, ResourceKey<Level> toWorldKey, BlockPos blockPos, JAMDRegistry.RegistrySet registrySet) {
        ServerLevel toWorld = playerEntity.m_20194_().m_129880_(toWorldKey);
        if (toWorld != null) {
            TelerportUtils.findPortalLocation((Level)toWorld, blockPos, registrySet).ifPresentOrElse(portalLocation -> {
                if (toWorld.m_8055_(portalLocation).m_60795_()) {
                    toWorld.m_46597_(portalLocation, ((Block)registrySet.block().get()).m_49966_());
                }
                Vec3 portalLocationVec = new Vec3((double)portalLocation.m_123341_() + 0.5, (double)(portalLocation.m_123342_() + 1), (double)portalLocation.m_123343_() + 0.5);
                Services.PLATFORM.teleport((Entity)playerEntity, toWorld, new PortalInfo(portalLocationVec, playerEntity.m_20184_(), playerEntity.m_146908_(), playerEntity.m_146909_()));
            }, () -> playerEntity.m_5661_((Component)Component.m_237115_((String)"jamd.invalid.pos"), true));
        } else {
            playerEntity.m_5661_((Component)Component.m_237110_((String)"jamd.invalid.world", (Object[])new Object[]{toWorldKey.m_135782_().toString()}), true);
        }
    }

    private static Optional<BlockPos> findPortalLocation(Level worldTo, BlockPos fromPos, JAMDRegistry.RegistrySet registrySet) {
        if (worldTo.m_8055_(fromPos).m_60713_((Block)registrySet.block().get()) && TelerportUtils.isSafeSpawnLocation(worldTo, fromPos)) {
            return Optional.of(fromPos.m_7494_());
        }
        int range = 5;
        return Optional.ofNullable(ChunkPos.m_45596_((ChunkPos)worldTo.m_46745_(fromPos).m_7697_(), (int)range).map(chunkPos -> worldTo.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_5928_()).flatMap(Collection::stream).toList().stream().filter(pos -> worldTo.m_7702_(pos).m_58903_().equals(registrySet.blockEntity().get())).findFirst().orElseGet(() -> {
            BlockPos heightmapPos = worldTo.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, fromPos);
            if (TelerportUtils.forLocationAround(worldTo, heightmapPos.m_122032_(), fromPos.m_123341_(), fromPos.m_123343_(), heightmapPos.m_123342_())) {
                return heightmapPos;
            }
            return null;
        }));
    }

    private static boolean forLocationAround(Level levelTo, BlockPos.MutableBlockPos blockPos, int fromX, int fromZ, int y) {
        for (int x = fromX - 6; x < fromX + 6; ++x) {
            for (int z = fromZ - 6; z < fromZ + 6; ++z) {
                blockPos.m_122178_(x, y, z);
                if (!TelerportUtils.isSaveLocation(levelTo, blockPos)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSaveLocation(Level levelTo, BlockPos.MutableBlockPos blockPos) {
        BlockState blockState = levelTo.m_8055_((BlockPos)blockPos);
        return blockState.m_60795_() && TelerportUtils.isSafeSpawnLocation(levelTo, blockPos.m_7494_());
    }

    private static boolean isSafeSpawnLocation(Level world, BlockPos blockPos) {
        return world.m_46739_(blockPos) && world.m_8055_(blockPos).m_60795_() && world.m_8055_(blockPos.m_7494_()).m_60795_();
    }
}

