/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.biome;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.unrealdinnerbone.config.exception.ConfigException;
import com.unrealdinnerbone.jamd.JAMD;
import com.unrealdinnerbone.jamd.JAMDForgeRegistry;
import com.unrealdinnerbone.jamd.JAMDRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.OreFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

public class JAMDBiomeModifier
implements BiomeModifier {
    public static final JAMDBiomeModifier INSTANCE = new JAMDBiomeModifier();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Pattern> matches;
    private final boolean dynamicOreAddition;
    private final List<ResourceKey<PlacedFeature>> placedFeatures;

    public JAMDBiomeModifier() {
        try {
            this.dynamicOreAddition = (Boolean)JAMD.CONFIG.getDynamicOreAdditionConfig().getExceptionally();
            this.matches = Arrays.stream((String[])JAMD.CONFIG.getBlackListedOresConfig().getExceptionally()).filter(Objects::nonNull).map(Pattern::compile).toList();
            this.placedFeatures = new ArrayList<ResourceKey<PlacedFeature>>();
            Arrays.stream((String[])JAMD.CONFIG.getAdditionalOresConfig().getExceptionally()).filter(Objects::nonNull).forEach(resourceLocation -> {
                try {
                    ResourceLocation p135787 = new ResourceLocation(resourceLocation);
                    ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)p135787);
                    this.placedFeatures.add((ResourceKey<PlacedFeature>)key);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to create key for {} ", resourceLocation, (Object)e);
                }
            });
        }
        catch (ConfigException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (this.dynamicOreAddition && phase == BiomeModifier.Phase.ADD) {
            if (biome.m_203565_(JAMDRegistry.Keys.OVERWORLD.biome())) {
                HolderLookup.RegistryLookup placedFeatureRegistryLookup = (HolderLookup.RegistryLookup)ServerLifecycleHooks.getCurrentServer().m_206579_().m_254861_(Registries.f_256988_).orElseThrow();
                this.handle((HolderLookup.RegistryLookup<PlacedFeature>)placedFeatureRegistryLookup, builder);
            } else if (biome.m_203565_(JAMDRegistry.Keys.NETHER.biome())) {
                HolderLookup.RegistryLookup placedFeatureRegistryLookup = (HolderLookup.RegistryLookup)ServerLifecycleHooks.getCurrentServer().m_206579_().m_254861_(Registries.f_256988_).orElseThrow();
                this.handle((HolderLookup.RegistryLookup<PlacedFeature>)placedFeatureRegistryLookup, builder);
            } else if (biome.m_203565_(JAMDRegistry.Keys.END.biome())) {
                HolderLookup.RegistryLookup placedFeatureRegistryLookup = (HolderLookup.RegistryLookup)ServerLifecycleHooks.getCurrentServer().m_206579_().m_254861_(Registries.f_256988_).orElseThrow();
                this.handle((HolderLookup.RegistryLookup<PlacedFeature>)placedFeatureRegistryLookup, builder);
            }
        }
    }

    private void handle(HolderLookup.RegistryLookup<PlacedFeature> placedFeatureRegistryLookup, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        for (ResourceKey<PlacedFeature> placedFeature2 : this.placedFeatures) {
            placedFeatureRegistryLookup.m_254902_(placedFeature2).ifPresent(placedFeature1 -> {
                List features = builder.getGenerationSettings().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES);
                if (features.stream().noneMatch(holder -> holder.m_203565_(placedFeature2))) {
                    LOGGER.debug("Force Adding: " + placedFeature2.m_135782_());
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)placedFeature1);
                } else {
                    LOGGER.debug("Skipping Force Added as it already exists: " + placedFeature2.m_135782_());
                }
            });
        }
        placedFeatureRegistryLookup.m_214062_().forEach(placedFeature -> {
            if (!this.matches(placedFeature.m_205785_().m_135782_().toString())) {
                PlacedFeature s = (PlacedFeature)placedFeature.get();
                boolean isOreFeature = ((ConfiguredFeature)s.f_191775_().get()).f_65377_() instanceof OreFeature;
                if (isOreFeature) {
                    LOGGER.debug("Adding: " + placedFeature.m_205785_().m_135782_());
                    List features = builder.getGenerationSettings().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES);
                    if (features.stream().noneMatch(holder -> holder.m_203565_(placedFeature.m_205785_()))) {
                        builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)placedFeature);
                    }
                }
            } else {
                LOGGER.debug("Blacklisted: " + placedFeature.m_205785_().m_135782_());
            }
        });
    }

    private boolean matches(String value) {
        return this.matches.stream().anyMatch(pattern -> pattern.matcher(value).matches());
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)JAMDForgeRegistry.BIOME_MODIFER.get();
    }
}

