/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd;

import com.mojang.serialization.Codec;
import com.unrealdinnerbone.jamd.block.EndBlockEntity;
import com.unrealdinnerbone.jamd.block.EndPortalBlock;
import com.unrealdinnerbone.jamd.block.NetherBlockEntity;
import com.unrealdinnerbone.jamd.block.NetherPortalBlock;
import com.unrealdinnerbone.jamd.block.OverworldBlockEntity;
import com.unrealdinnerbone.jamd.block.OverworldPortalBlock;
import com.unrealdinnerbone.jamd.block.base.PortalTileEntity;
import com.unrealdinnerbone.jamd.world.CustomFlatLevelSource;
import com.unrealdinnerbone.trenzalore.api.platform.services.IRegistry;
import com.unrealdinnerbone.trenzalore.api.registry.Regeneration;
import com.unrealdinnerbone.trenzalore.api.registry.RegistryEntry;
import com.unrealdinnerbone.trenzalore.api.registry.RegistryObjects;
import com.unrealdinnerbone.trenzalore.lib.CreativeTabs;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.ApiStatus;

public class JAMDRegistry
implements IRegistry {
    private static final RegistryObjects<Block> BLOCKS = Regeneration.create((ResourceKey)Registries.f_256747_);
    private static final RegistryObjects<Item> ITEMS = Regeneration.create((ResourceKey)Registries.f_256913_);
    private static final RegistryObjects<BlockEntityType<?>> TILES = Regeneration.create((ResourceKey)Registries.f_256922_);
    private static final RegistryObjects<Codec<? extends ChunkGenerator>> CHUNK_GENERATORS = Regeneration.create((ResourceKey)Registries.f_256783_);
    public static final RegistryEntry<Codec<? extends ChunkGenerator>> CUSTOM_FLAT_LEVEL_SOURCE = CHUNK_GENERATORS.register("mining", () -> CustomFlatLevelSource.CODEC);
    public static final RegistrySet OVERWORLD = RegistrySet.of("portal_block", "portal", OverworldPortalBlock::new, OverworldBlockEntity::new);
    public static final RegistrySet NETHER = RegistrySet.of("nether_portal", NetherPortalBlock::new, NetherBlockEntity::new);
    public static final RegistrySet END = RegistrySet.of("end_portal", EndPortalBlock::new, EndBlockEntity::new);

    public void afterRegistered() {
        Regeneration.addItemsToCreateTab((ResourceKey)CreativeTabs.FUNCTIONAL_BLOCKS, List.of(OVERWORLD.item(), NETHER.item(), END.item()));
    }

    public List<RegistryObjects<?>> getRegistryObjects() {
        return List.of(BLOCKS, ITEMS, TILES, CHUNK_GENERATORS);
    }

    public String getModID() {
        return "jamd";
    }

    public record RegistrySet(RegistryEntry<Block> block, RegistryEntry<BlockItem> item, RegistryEntry<BlockEntityType<PortalTileEntity>> blockEntity) {
        private static RegistrySet of(String name, Supplier<Block> blockSupplier, BiFunction<BlockPos, BlockState, PortalTileEntity> tileSupplier) {
            return RegistrySet.of(name, name, blockSupplier, tileSupplier);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="4.0.0")
        private static RegistrySet of(String blockName, String tileName, Supplier<Block> blockSupplier, BiFunction<BlockPos, BlockState, PortalTileEntity> tileSupplier) {
            RegistryEntry block = BLOCKS.register(blockName, blockSupplier);
            RegistryEntry itemBlock = ITEMS.register(blockName, () -> new BlockItem((Block)block.get(), new Item.Properties()));
            RegistryEntry tile = TILES.register(tileName, () -> Regeneration.createBlockEntityType((BiFunction)tileSupplier, (Block[])new Block[]{(Block)block.get()}));
            return new RegistrySet((RegistryEntry<Block>)block, (RegistryEntry<BlockItem>)itemBlock, (RegistryEntry<BlockEntityType<PortalTileEntity>>)tile);
        }
    }

    public record KeySet(ResourceKey<Level> level, ResourceKey<DimensionType> dimensionType, ResourceKey<Biome> biome) {
        private static KeySet of(ResourceLocation id) {
            return new KeySet((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)id), (ResourceKey<DimensionType>)ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)id), (ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)id));
        }
    }

    public static class Keys {
        public static final KeySet OVERWORLD = KeySet.of(new ResourceLocation("jamd", "mining"));
        public static final KeySet NETHER = KeySet.of(new ResourceLocation("jamd", "nether"));
        public static final KeySet END = KeySet.of(new ResourceLocation("jamd", "end"));
    }
}

