/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.trenzalore.platform;

import com.unrealdinnerbone.trenzalore.api.platform.services.IPlatformHelper;
import com.unrealdinnerbone.trenzalore.api.registry.RegistryObjects;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ForgePlatformHelper
implements IPlatformHelper {
    private static final Map<ResourceKey<CreativeModeTab>, List<Supplier<? extends Item>>> CREATIVE_TAB_MAP = new HashMap<ResourceKey<CreativeModeTab>, List<Supplier<? extends Item>>>();

    @Override
    public String getPlatform() {
        return "Forge";
    }

    @Override
    public Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public <T> void registryRegistryObjects(String modId, RegistryObjects<T> registryObjects) {
        DeferredRegister deferredRegister = DeferredRegister.create(registryObjects.registryKey(), (String)modId);
        registryObjects.objects().forEach(registryEntry -> deferredRegister.register(registryEntry.name(), registryEntry.entry()));
        deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @Override
    public void addItemToCreativeTab(ResourceKey<CreativeModeTab> tabResourceKey, List<Supplier<? extends Item>> item) {
        if (CREATIVE_TAB_MAP.containsKey(tabResourceKey)) {
            CREATIVE_TAB_MAP.get(tabResourceKey).addAll(item);
        } else {
            CREATIVE_TAB_MAP.put(tabResourceKey, new ArrayList<Supplier<? extends Item>>(item));
        }
    }

    @Override
    @Nullable
    public <T extends Entity> Entity teleportInternal(T entity, ServerLevel level, PortalInfo portalInfo) {
        return entity.changeDimension(level, (ITeleporter)new SimpleTeleporter(portalInfo));
    }

    @ApiStatus.Internal
    public static Map<ResourceKey<CreativeModeTab>, List<Supplier<? extends Item>>> getCreativeTabMap() {
        return CREATIVE_TAB_MAP;
    }

    public record SimpleTeleporter(PortalInfo portalInfo) implements ITeleporter
    {
        @Nullable
        public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return this.portalInfo;
        }
    }
}

