/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.util;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;

public class Utils {
    public static double cosNoise(double time) {
        return Utils.cosNoise(time, 5);
    }

    public static double cosNoise(double time, int layers) {
        double value = 0.0;
        for (int i = 0; i < layers; ++i) {
            value += Math.cos(time);
            time *= 1.3;
        }
        return value;
    }

    public static List<Pair<Holder<BannerPattern>, DyeColor>> parseBannerItem(ItemStack banner) {
        DyeColor baseColor = ((BannerItem)banner.m_41720_()).m_40545_();
        CompoundTag nbtCompound = BlockItem.m_186336_((ItemStack)banner);
        if (nbtCompound == null || !nbtCompound.m_128441_("Patterns")) {
            return List.of(Pair.of((Object)BuiltInRegistries.f_256878_.m_246971_(BannerPatterns.f_222726_), (Object)baseColor));
        }
        ListTag nbtList = nbtCompound.m_128437_("Patterns", 10);
        return BannerBlockEntity.m_58484_((DyeColor)baseColor, (ListTag)nbtList);
    }
}

