/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.s2c;

import immersive_aircraft.entity.misc.AircraftBaseUpgradeRegistry;
import immersive_aircraft.item.upgrade.AircraftUpgrade;
import immersive_aircraft.network.s2c.AircraftUpgradesMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class AircraftBaseUpgradesMessage
extends AircraftUpgradesMessage {
    private final Map<EntityType<?>, AircraftUpgrade> upgrades;

    public AircraftBaseUpgradesMessage() {
        this.upgrades = AircraftBaseUpgradeRegistry.INSTANCE.getAll();
    }

    public AircraftBaseUpgradesMessage(FriendlyByteBuf buffer) {
        this.upgrades = new HashMap();
        int upgradeCount = buffer.readInt();
        for (int i = 0; i < upgradeCount; ++i) {
            EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(buffer.m_130281_());
            this.upgrades.put(type, this.readUpgrade(buffer));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        Map<EntityType<?>, AircraftUpgrade> upgrades = AircraftBaseUpgradeRegistry.INSTANCE.getAll();
        buffer.writeInt(upgrades.size());
        for (EntityType<?> type : upgrades.keySet()) {
            buffer.m_130085_(BuiltInRegistries.f_256780_.m_7981_(type));
            this.writeUpgrade(buffer, upgrades.get(type));
        }
    }

    @Override
    public void receive(Player player) {
        AircraftBaseUpgradeRegistry.INSTANCE.replace(this.upgrades);
    }
}

