/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class QuadrocopterEntity
extends Rotorcraft {
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setPitchSpeed(1.5f).setEngineSpeed(0.0325f).setVerticalSpeed(0.0325f).setGlideFactor(0.0f).setDriftDrag(0.005f).setLift(0.1f).setRollFactor(15.0f).setWindSensitivity(0.0125f).setMass(1.0f);
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 22).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 50, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 14).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 98, 8, 3, 2).build();
    final List<List<Vector3f>> PASSENGER_POSITIONS = List.of(List.of(new Vector3f(0.0f, 0.275f, -0.1f)));

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public QuadrocopterEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    @Override
    protected float getBaseFuelConsumption() {
        return 0.5f;
    }

    @Override
    protected float getInputInterpolationSteps() {
        return 5.0f;
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER_TINY.get();
    }

    @Override
    protected float getEnginePitch() {
        return 1.0f;
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected float getGroundVelocityDecay() {
        return 0.25f;
    }

    @Override
    protected float getHorizontalVelocityDelay() {
        return 0.9f;
    }

    @Override
    protected float getVerticalVelocityDelay() {
        return 0.8f;
    }

    @Override
    protected float getStabilizer() {
        return 0.1f;
    }

    @Override
    public Item asItem() {
        return Items.QUADROCOPTER.get();
    }

    @Override
    protected List<List<Vector3f>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    protected float getGravity() {
        return this.f_19798_ ? 0.04f : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    protected void updateController() {
        super.updateController();
        this.setEngineTarget(1.0f);
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(this.getEnginePower() * this.properties.getVerticalSpeed() * this.pressingInterpolatedY.getSmooth()), 0.0));
        Vector3f direction = this.getForwardDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.properties.getEngineSpeed()) * this.pressingInterpolatedZ.getSmooth();
        Vector3f f2 = direction.mul(thrust);
        this.m_20256_(this.m_20184_().m_82520_((double)f2.x, (double)f2.y, (double)f2.z));
    }
}

