/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public abstract class AirplaneEntity
extends EngineAircraft {
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setPitchSpeed(4.0f).setEngineSpeed(0.0225f).setGlideFactor(0.05f).setDriftDrag(0.01f).setLift(0.15f).setRollFactor(45.0f).setGroundPitch(4.0f).setWindSensitivity(0.025f).setMass(1.0f);

    public AirplaneEntity(EntityType<? extends AircraftEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    @Override
    protected boolean useAirplaneControls() {
        return true;
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected float getGroundVelocityDecay() {
        return this.falloffGroundVelocityDecay(0.9f);
    }

    @Override
    protected float getGravity() {
        Vector3f direction = this.getForwardDirection();
        float speed = (float)this.m_20184_().m_82553_() * (1.0f - Math.abs(direction.y));
        return Math.max(0.0f, 1.0f - speed * 1.5f) * super.getGravity();
    }

    protected float getBrakeFactor() {
        return 0.95f;
    }

    @Override
    protected void updateController() {
        if (!this.m_20160_()) {
            return;
        }
        super.updateController();
        if (this.movementY != 0.0f) {
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + 0.1f * this.movementY)));
            if (this.movementY < 0.0f) {
                this.m_20256_(this.m_20184_().m_82490_((double)this.getBrakeFactor()));
            }
        }
        Vector3f direction = this.getForwardDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.properties.getEngineSpeed());
        this.m_20256_(this.m_20184_().m_82549_(this.toVec3d(direction.mul(thrust))));
    }
}

