/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import immersive_aircraft.Main;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.item.upgrade.AircraftUpgrade;
import immersive_aircraft.item.upgrade.AircraftUpgradeRegistry;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;

public class UpgradeDataLoader
extends SimpleJsonResourceReloadListener {
    public UpgradeDataLoader() {
        super(new Gson(), "aircraft_upgrades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager manager, ProfilerFiller profiler) {
        AircraftUpgradeRegistry.INSTANCE.reset();
        jsonMap.forEach((identifier, jsonElement) -> {
            try {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (BuiltInRegistries.f_257033_.m_7804_(identifier)) {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(identifier);
                    AircraftUpgrade upgrade = new AircraftUpgrade();
                    for (String key : jsonObject.keySet()) {
                        AircraftStat stat = AircraftUpgradeRegistry.STATS.get(key);
                        if (stat == null) continue;
                        upgrade.set(stat, jsonObject.get(key).getAsFloat());
                    }
                    AircraftUpgradeRegistry.INSTANCE.setUpgrade(item, upgrade);
                }
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Main.LOGGER.error("Parsing error on aircraft upgrade {}: {}", identifier, (Object)exception.getMessage());
            }
        });
    }
}

