/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import immersive_aircraft.client.render.entity.renderer.TrailRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.resources.ObjectLoader;
import immersive_aircraft.util.obj.Face;
import immersive_aircraft.util.obj.FaceVertex;
import immersive_aircraft.util.obj.Mesh;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class AircraftEntityRenderer<T extends AircraftEntity>
extends EntityRenderer<T> {
    public AircraftEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected abstract Model getModel(AircraftEntity var1);

    protected abstract Vector3f getPivot(AircraftEntity var1);

    public void render(T entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        PoseStack.Pose peek = matrixStack.m_85850_();
        matrixStack.m_85836_();
        float h = (float)((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleTicks() - tickDelta;
        float j = ((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleStrength() - tickDelta;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)h) * h * j / 10.0f * (float)((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleSide()));
        }
        Vector3f effect = entity.m_20096_() ? new Vector3f(0.0f, 0.0f, 0.0f) : ((AircraftEntity)((java.lang.Object)entity)).getWindEffect();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(entity.m_5686_(tickDelta) + effect.z));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(((VehicleEntity)((java.lang.Object)entity)).getRoll(tickDelta) + effect.x));
        Vector3f pivot = this.getPivot((AircraftEntity)((java.lang.Object)entity));
        matrixStack.m_252880_(pivot.x, pivot.y, pivot.z);
        Model model = this.getModel((AircraftEntity)((java.lang.Object)entity));
        for (Object object : model.getObjects()) {
            if (object.getAnimationConsumer() != null) {
                matrixStack.m_85836_();
                object.getAnimationConsumer().run(entity, yaw, tickDelta, matrixStack);
            }
            object.getRenderConsumer().run(vertexConsumerProvider, entity, matrixStack, light, tickDelta);
            if (object.getAnimationConsumer() == null) continue;
            matrixStack.m_85849_();
        }
        ((AircraftEntity)((java.lang.Object)entity)).getTrails().forEach(t -> TrailRenderer.render(t, vertexConsumerProvider, peek));
        matrixStack.m_85849_();
        super.m_7392_(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    protected static void renderObject(Mesh mesh, PoseStack matrixStack, VertexConsumer vertexConsumer, int light) {
        AircraftEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected static void renderObject(Mesh mesh, PoseStack matrixStack, VertexConsumer vertexConsumer, int light, float r, float g, float b, float a) {
        PoseStack.Pose entry = matrixStack.m_85850_();
        Matrix4f positionMatrix = entry.m_252922_();
        Matrix3f normalMatrix = entry.m_252943_();
        for (Face face : mesh.faces) {
            if (face.vertices.size() != 4) continue;
            for (FaceVertex v : face.vertices) {
                vertexConsumer.m_252986_(positionMatrix, v.v.x, v.v.y, v.v.z).m_85950_(r, g, b, a).m_7421_(v.t.u, v.t.v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, v.n.x, v.n.y, v.n.z).m_5752_();
            }
        }
    }

    protected static void renderSailObject(Mesh mesh, PoseStack matrixStack, VertexConsumer vertexConsumer, int light, double time) {
        AircraftEntityRenderer.renderSailObject(mesh, matrixStack, vertexConsumer, light, time, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected static void renderSailObject(Mesh mesh, PoseStack matrixStack, VertexConsumer vertexConsumer, int light, double time, float r, float g, float b, float a) {
        PoseStack.Pose entry = matrixStack.m_85850_();
        Matrix4f positionMatrix = entry.m_252922_();
        Matrix3f normalMatrix = entry.m_252943_();
        for (Face face : mesh.faces) {
            if (face.vertices.size() != 4) continue;
            for (FaceVertex v : face.vertices) {
                double angle = (double)(v.v.x + v.v.z) + (double)v.v.y * 0.25 + time * 0.25;
                double scale = 0.05;
                float x = (float)((double)v.v.x + (Math.cos(angle) + Math.cos(angle * 1.7)) * scale * (double)v.c.r);
                float z = (float)((double)v.v.z + (Math.sin(angle) + Math.sin(angle * 1.7)) * scale * (double)v.c.r);
                vertexConsumer.m_252986_(positionMatrix, x, v.v.y, z).m_85950_(r, g, b, a).m_7421_(v.t.u, v.t.v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, v.n.x, v.n.y, v.n.z).m_5752_();
            }
        }
    }

    protected static void renderBanner(PoseStack matrixStack, MultiBufferSource vertexConsumers, int light, Mesh mesh, boolean isBanner, List<Pair<Holder<BannerPattern>, DyeColor>> patterns) {
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<Holder<BannerPattern>, DyeColor> pair = patterns.get(i);
            float[] fs = ((DyeColor)pair.getSecond()).m_41068_();
            Holder bannerPattern = (Holder)pair.getFirst();
            bannerPattern.m_203543_().ifPresent(key -> {
                Material spriteIdentifier = isBanner ? Sheets.m_234347_((ResourceKey)key) : Sheets.m_234349_((ResourceKey)key);
                VertexConsumer vertexConsumer = spriteIdentifier.m_119194_(vertexConsumers, RenderType::m_110482_);
                TextureAtlasSprite sprite = spriteIdentifier.m_119204_();
                PoseStack.Pose entry = matrixStack.m_85850_();
                Matrix4f positionMatrix = entry.m_252922_();
                Matrix3f normalMatrix = entry.m_252943_();
                for (Face face : mesh.faces) {
                    if (face.vertices.size() != 4) continue;
                    for (FaceVertex v : face.vertices) {
                        vertexConsumer.m_252986_(positionMatrix, v.v.x, v.v.y, v.v.z).m_85950_(fs[0], fs[1], fs[2], 1.0f).m_7421_(v.t.u * (sprite.m_118410_() - sprite.m_118409_()) + sprite.m_118409_(), v.t.v * (sprite.m_118412_() - sprite.m_118411_()) + sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, v.n.x, v.n.y, v.n.z).m_5752_();
                    }
                }
            });
        }
    }

    protected static Mesh getFaces(ResourceLocation id, String object) {
        return ObjectLoader.objects.get(id).get(object);
    }

    public boolean shouldRender(T entity, Frustum frustum, double x, double y, double z) {
        if (!entity.m_6000_(x, y, z)) {
            return false;
        }
        AABB box = entity.m_6921_().m_82400_(2.5);
        return frustum.m_113029_(box);
    }

    protected class Model {
        private final List<Object> objects = new LinkedList<Object>();

        public Model add(Object o) {
            this.objects.add(o);
            return this;
        }

        public List<Object> getObjects() {
            return this.objects;
        }
    }

    protected class Object {
        private final ResourceLocation id;
        private final String object;
        private AnimationConsumer<T> animationConsumer = null;
        private RenderConsumer<T> renderConsumer = (vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
            ResourceLocation identifier = AircraftEntityRenderer.this.m_5478_((Entity)entity);
            VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110452_((ResourceLocation)identifier));
            AircraftEntityRenderer.renderObject(this.getMesh(), matrixStack, vertexConsumer, light);
        };

        public Object(ResourceLocation id, String object) {
            this.id = id;
            this.object = object;
        }

        public Mesh getMesh() {
            Mesh mesh = AircraftEntityRenderer.getFaces(this.id, this.object);
            if (mesh == null) {
                throw new RuntimeException(String.format("Mesh %s in %s does not exist!", this.id, this.object));
            }
            return mesh;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public AnimationConsumer<T> getAnimationConsumer() {
            return this.animationConsumer;
        }

        public Object setAnimationConsumer(AnimationConsumer<T> animationConsumer) {
            this.animationConsumer = animationConsumer;
            return this;
        }

        public RenderConsumer<T> getRenderConsumer() {
            return this.renderConsumer;
        }

        public Object setRenderConsumer(RenderConsumer<T> renderConsumer) {
            this.renderConsumer = renderConsumer;
            return this;
        }

        public static interface AnimationConsumer<T> {
            public void run(T var1, float var2, float var3, PoseStack var4);
        }

        public static interface RenderConsumer<T> {
            public void run(MultiBufferSource var1, T var2, PoseStack var3, int var4, float var5);
        }
    }
}

