/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import immersive_aircraft.Main;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.screen.VehicleScreenHandler;
import immersive_aircraft.util.Rect2iCommon;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class VehicleScreen
extends AbstractContainerScreen<VehicleScreenHandler> {
    private static final ResourceLocation TEXTURE = Main.locate("textures/gui/container/inventory.png");
    public static int titleHeight = 10;
    public static int baseHeight = 86;
    public int containerSize;

    public VehicleScreen(VehicleScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.containerSize = handler.getVehicle().getInventoryDescription().getHeight();
        this.f_97727_ = baseHeight + this.containerSize + titleHeight * 2;
        this.f_97731_ = this.containerSize + titleHeight;
    }

    protected void m_7286_(@NotNull GuiGraphics context, float delta, int mouseX, int mouseY) {
    }

    protected void drawRectangle(GuiGraphics context, int x, int y, int h, int w) {
        context.m_280163_(TEXTURE, x, y, 176.0f, 0.0f, 16, 16, 512, 256);
        context.m_280163_(TEXTURE, x + w - 16, y, 208.0f, 0.0f, 16, 16, 512, 256);
        context.m_280163_(TEXTURE, x + w - 16, y + h - 16, 208.0f, 32.0f, 16, 16, 512, 256);
        context.m_280163_(TEXTURE, x, y + h - 16, 176.0f, 32.0f, 16, 16, 512, 256);
        context.m_280411_(TEXTURE, x + 16, y, w - 32, 16, 192.0f, 0.0f, 16, 16, 512, 256);
        context.m_280411_(TEXTURE, x + 16, y + h - 16, w - 32, 16, 192.0f, 32.0f, 16, 16, 512, 256);
        context.m_280411_(TEXTURE, x, y + 16, 16, h - 32, 176.0f, 16.0f, 16, 16, 512, 256);
        context.m_280411_(TEXTURE, x + w - 16, y + 16, 16, h - 32, 208.0f, 16.0f, 16, 16, 512, 256);
        context.m_280411_(TEXTURE, x + 16, y + 16, w - 32, h - 32, 192.0f, 16.0f, 16, 16, 512, 256);
    }

    protected void drawCustomBackground(GuiGraphics context) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.containerSize + titleHeight * 2, 512, 256);
        context.m_280163_(TEXTURE, this.f_97735_, this.f_97736_ + this.containerSize + titleHeight * 2 - 4, 0.0f, (float)(222 - baseHeight), this.f_97726_, baseHeight, 512, 256);
        for (Rect2iCommon rectangle : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getRectangles()) {
            this.drawRectangle(context, this.f_97735_ + rectangle.getX(), this.f_97736_ + rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        }
    }

    private void drawImage(GuiGraphics context, int x, int y, int u, int v, int w, int h) {
        context.m_280163_(TEXTURE, x, y, (float)u, (float)v, w, h, 512, 256);
    }

    public void m_88315_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.drawCustomBackground(context);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int titleHeight = 10;
        block11: for (VehicleInventoryDescription.Slot slot : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getSlots()) {
            block0 : switch (slot.type) {
                case INVENTORY: {
                    this.drawImage(context, this.f_97735_ + slot.x - 1, this.f_97736_ + titleHeight + slot.y - 1, 284, 0, 18, 18);
                    break;
                }
                case BOILER: {
                    EngineAircraft engineAircraft;
                    this.drawImage(context, this.f_97735_ + slot.x - 4, this.f_97736_ + titleHeight + slot.y - 18, 318, 0, 24, 39);
                    InventoryVehicleEntity inventoryVehicleEntity = ((VehicleScreenHandler)this.f_97732_).getVehicle();
                    if (!(inventoryVehicleEntity instanceof EngineAircraft) || !((double)(engineAircraft = (EngineAircraft)inventoryVehicleEntity).getFuelUtilization() > 0.0)) continue block11;
                    this.drawImage(context, this.f_97735_ + slot.x - 4, this.f_97736_ + titleHeight + slot.y - 18, 348, 0, 24, 39);
                    break;
                }
                default: {
                    if (((VehicleScreenHandler)this.f_97732_).getVehicle().getInventory().m_8020_(slot.index).m_41619_()) {
                        switch (slot.type) {
                            case WEAPON: {
                                this.drawImage(context, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 22, 22, 22);
                                break block0;
                            }
                            case UPGRADE: {
                                this.drawImage(context, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 44, 22, 22);
                                break block0;
                            }
                            case BANNER: {
                                this.drawImage(context, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 66, 22, 22);
                                break block0;
                            }
                            case DYE: {
                                this.drawImage(context, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 88, 22, 22);
                                break block0;
                            }
                            case BOOSTER: {
                                this.drawImage(context, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 110, 22, 22);
                            }
                        }
                        break;
                    }
                    this.drawImage(context, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 0, 22, 22);
                }
            }
        }
        super.m_88315_(context, mouseX, mouseY, delta);
        if (this.f_97734_ != null && !this.f_97734_.m_6657_() && this.f_97734_.f_40218_ == ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventory()) {
            VehicleInventoryDescription.Slot slot = ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getSlots().get(this.f_97734_.m_150661_());
            if (slot.type == VehicleInventoryDescription.SlotType.DYE || slot.type == VehicleInventoryDescription.SlotType.BOOSTER || slot.type == VehicleInventoryDescription.SlotType.BOILER || slot.type == VehicleInventoryDescription.SlotType.UPGRADE || slot.type == VehicleInventoryDescription.SlotType.BANNER || slot.type == VehicleInventoryDescription.SlotType.WEAPON) {
                context.m_280677_(this.f_96547_, List.of(Component.m_237115_((String)("immersive_aircraft.slot." + slot.type.name().toLowerCase(Locale.ROOT)))), Optional.empty(), mouseX, mouseY);
            }
        } else {
            this.m_280072_(context, mouseX, mouseY);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        if (super.m_7467_(mouseX, mouseY, left, top, button)) {
            for (Rect2iCommon rectangle : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getRectangles()) {
                if (!(mouseX > (double)(rectangle.getX() + this.f_97735_)) || !(mouseX < (double)(rectangle.getX() + rectangle.getWidth() + this.f_97735_)) || !(mouseY > (double)(rectangle.getY() + this.f_97736_)) || !(mouseY < (double)(rectangle.getY() + rectangle.getHeight() + this.f_97736_))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getX() {
        return this.f_97735_;
    }

    public int getY() {
        return this.f_97736_;
    }
}

