/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client;

import com.mojang.blaze3d.platform.InputConstants;
import immersive_aircraft.client.FallbackKeyMapping;
import immersive_aircraft.client.MultiKeyMapping;
import immersive_aircraft.config.Config;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;

public class KeyBindings {
    public static final List<KeyMapping> list = new LinkedList<KeyMapping>();
    public static final KeyMapping left;
    public static final KeyMapping right;
    public static final KeyMapping forward;
    public static final KeyMapping backward;
    public static final KeyMapping up;
    public static final KeyMapping down;
    public static final KeyMapping pull;
    public static final KeyMapping push;
    public static final KeyMapping dismount;
    public static final KeyMapping boost;

    private static KeyMapping newFallbackKey(String name, Supplier<KeyMapping> fallback) {
        FallbackKeyMapping key = new FallbackKeyMapping("key.immersive_aircraft." + name, InputConstants.Type.KEYSYM, fallback, "itemGroup.immersive_aircraft.immersive_aircraft_tab");
        list.add(key);
        return key;
    }

    private static KeyMapping newKey(String name, int code) {
        KeyMapping key = new KeyMapping("key.immersive_aircraft." + name, InputConstants.Type.KEYSYM, code, "itemGroup.immersive_aircraft.immersive_aircraft_tab");
        list.add(key);
        return key;
    }

    private static KeyMapping newMultiKey(String name, int defaultKey) {
        MultiKeyMapping key = new MultiKeyMapping("key.immersive_aircraft." + name, InputConstants.Type.KEYSYM, defaultKey, "itemGroup.immersive_aircraft.immersive_aircraft_tab");
        list.add(key);
        return key;
    }

    static {
        if (Config.getInstance().useCustomKeybindSystem) {
            left = KeyBindings.newMultiKey("multi_control_left", 65);
            right = KeyBindings.newMultiKey("multi_control_right", 68);
            forward = KeyBindings.newMultiKey("multi_control_forward", 87);
            backward = KeyBindings.newMultiKey("multi_control_backward", 83);
            up = KeyBindings.newMultiKey("multi_control_up", 32);
            down = KeyBindings.newMultiKey("multi_control_down", 340);
            pull = KeyBindings.newMultiKey("multi_control_pull", 83);
            push = KeyBindings.newMultiKey("multi_control_push", 87);
            dismount = KeyBindings.newMultiKey("multi_dismount", 82);
            boost = KeyBindings.newMultiKey("multi_boost", 66);
        } else {
            Minecraft client = Minecraft.m_91087_();
            left = KeyBindings.newFallbackKey("fallback_control_left", () -> client.f_91066_.f_92086_);
            right = KeyBindings.newFallbackKey("fallback_control_right", () -> client.f_91066_.f_92088_);
            forward = KeyBindings.newFallbackKey("fallback_control_forward", () -> client.f_91066_.f_92085_);
            backward = KeyBindings.newFallbackKey("fallback_control_backward", () -> client.f_91066_.f_92087_);
            up = KeyBindings.newFallbackKey("fallback_control_up", () -> client.f_91066_.f_92089_);
            down = KeyBindings.newFallbackKey("fallback_control_down", () -> client.f_91066_.f_92090_);
            pull = KeyBindings.newFallbackKey("fallback_control_pull", () -> client.f_91066_.f_92085_);
            push = KeyBindings.newFallbackKey("fallback_control_push", () -> client.f_91066_.f_92087_);
            dismount = KeyBindings.newKey("fallback_dismount", 82);
            boost = KeyBindings.newKey("fallback_boost", 66);
        }
    }
}

