/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.server.discord;

import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.discord.events.DiscordTraderSearchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TechDiscordEvents {
    @SubscribeEvent
    public static void onTraderSearch(DiscordTraderSearchEvent event) {
        block8: {
            EnergyTraderData energyTrader;
            TraderData trader;
            block7: {
                FluidTraderData fluidTrader;
                trader = event.getTrader();
                if (!(trader instanceof FluidTraderData) || !event.acceptTrader((TraderData)(fluidTrader = (FluidTraderData)trader))) break block7;
                boolean showStock = !fluidTrader.isCreative();
                boolean firstTrade = true;
                for (int i = 0; i < fluidTrader.getTradeCount(); ++i) {
                    String priceText;
                    String fluidName;
                    FluidStack sellFluid;
                    FluidTradeData trade = fluidTrader.getTrade(i);
                    if (!trade.isValid() || !event.acceptTradeType((TradeData)trade)) continue;
                    if (trade.isSale()) {
                        sellFluid = trade.getProduct();
                        fluidName = FluidFormatUtil.getFluidName(sellFluid).getString();
                        if (event.filterByTrades() && !event.getSearchText().isEmpty() && !fluidName.toLowerCase().contains(event.getSearchText())) continue;
                        if (firstTrade) {
                            event.addToOutput("--" + fluidTrader.getOwner().getOwnerName(false) + "'s **" + fluidTrader.getName().getString() + "**--");
                            firstTrade = false;
                        }
                        priceText = trade.getCost().getString();
                        event.addToOutput("Selling " + FluidFormatUtil.formatFluidAmount(trade.getQuantity()) + "mB of " + fluidName + " for " + priceText);
                        if (!showStock) continue;
                        event.addToOutput("*" + trade.getStock(fluidTrader) + " trades in stock.*");
                        continue;
                    }
                    if (!trade.isPurchase()) continue;
                    sellFluid = trade.getProduct();
                    fluidName = FluidFormatUtil.getFluidName(sellFluid).getString();
                    if (event.filterByTrades() && !event.getSearchText().isEmpty() && !fluidName.toLowerCase().contains(event.getSearchText())) continue;
                    if (firstTrade) {
                        event.addToOutput("--" + fluidTrader.getOwner().getOwnerName(false) + "'s **" + fluidTrader.getName().getString() + "**--");
                        firstTrade = false;
                    }
                    priceText = trade.getCost().getString();
                    event.addToOutput("Purchasing " + FluidFormatUtil.formatFluidAmount(trade.getQuantity()) + "mB of " + fluidName + " for " + priceText);
                    if (!showStock) continue;
                    event.addToOutput("*" + trade.getStock(fluidTrader) + " trades in stock.*");
                }
                break block8;
            }
            if (!(trader instanceof EnergyTraderData) || !event.acceptTrader((TraderData)(energyTrader = (EnergyTraderData)trader))) break block8;
            boolean showStock = !energyTrader.isCreative();
            boolean firstTrade = true;
            for (int i = 0; i < energyTrader.getTradeCount(); ++i) {
                String priceText;
                EnergyTradeData trade = energyTrader.getTrade(i);
                if (!trade.isValid() || !event.acceptTradeType((TradeData)trade) || event.filterByTrades() && !event.getSearchText().isEmpty() && !"FE".toLowerCase().contains(event.getSearchText()) && !"Energy".toLowerCase().contains(event.getSearchText())) continue;
                if (firstTrade) {
                    event.addToOutput("--" + energyTrader.getOwner().getOwnerName(false) + "'s **" + energyTrader.getName().getString() + "**--");
                    firstTrade = false;
                }
                if (trade.isSale()) {
                    priceText = trade.getCost().getString();
                    event.addToOutput("Selling " + EnergyUtil.formatEnergyAmount(trade.getAmount()) + " for " + priceText);
                    if (!showStock) continue;
                    event.addToOutput("*" + trade.getStock(energyTrader) + " trades in stock.*");
                    continue;
                }
                if (!trade.isPurchase()) continue;
                priceText = trade.getCost().getString();
                event.addToOutput("Purchasing " + EnergyUtil.formatEnergyAmount(trade.getAmount()) + " for " + priceText);
                if (!showStock) continue;
                event.addToOutput("*" + trade.getStock(energyTrader) + " trades in stock.*");
            }
        }
    }
}

