/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.fluid.tradedata.client;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid.FluidStorageClientTab;
import io.github.lightman314.lctech.client.gui.widget.button.trade.SpriteDisplayEntry;
import io.github.lightman314.lctech.common.menu.slots.FluidInputSlot;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class FluidTradeButtonRenderer
extends TradeRenderManager<FluidTradeData> {
    public FluidTradeButtonRenderer(FluidTradeData trade) {
        super((TradeData)trade);
    }

    public int tradeButtonWidth(TradeContext context) {
        return this.allowsDrainage(context) ? 87 : 76;
    }

    public LazyOptional<ScreenPosition> arrowPosition(TradeContext tradeContext) {
        if (((FluidTradeData)this.trade).isSale()) {
            return ScreenPosition.ofOptional((int)36, (int)1);
        }
        return ScreenPosition.ofOptional((int)18, (int)1);
    }

    public TradeButton.DisplayData inputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(1, 1, ((FluidTradeData)this.trade).isSale() ? 34 : 16, 16);
    }

    public List<TradeButton.DisplayEntry> getInputDisplays(TradeContext context) {
        if (((FluidTradeData)this.trade).isSale()) {
            return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of((CoinValue)((FluidTradeData)this.trade).getCost(context), context.isStorageMode ? Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"tooltip.lightmanscurrency.trader.price_edit")}) : null)});
        }
        if (((FluidTradeData)this.trade).isPurchase()) {
            return this.getFluidEntry(context);
        }
        return null;
    }

    public TradeButton.DisplayData outputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(((FluidTradeData)this.trade).isSale() ? 58 : 40, 1, ((FluidTradeData)this.trade).isSale() ? (this.allowsDrainage(context) ? 32 : 16) : 34, 16);
    }

    public List<TradeButton.DisplayEntry> getOutputDisplays(TradeContext context) {
        if (((FluidTradeData)this.trade).isSale()) {
            return this.getFluidEntry(context);
        }
        if (((FluidTradeData)this.trade).isPurchase()) {
            return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of((CoinValue)((FluidTradeData)this.trade).getCost(context), context.isStorageMode ? Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"tooltip.lightmanscurrency.trader.price_edit")}) : null)});
        }
        return null;
    }

    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        TraderData traderData;
        if (context.hasTrader() && (traderData = context.getTrader()) instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (!trader.isCreative()) {
                if (((FluidTradeData)this.trade).getStock(context) <= 0) {
                    alerts.add(AlertData.warn((MutableComponent)Component.m_237115_((String)"tooltip.lightmanscurrency.outofstock")));
                }
                if (!((FluidTradeData)this.trade).hasSpace(trader)) {
                    alerts.add(AlertData.warn((MutableComponent)Component.m_237115_((String)"tooltip.lightmanscurrency.outofspace")));
                }
            }
            if (!((FluidTradeData)this.trade).canAfford(context)) {
                alerts.add(AlertData.warn((MutableComponent)Component.m_237115_((String)"tooltip.lightmanscurrency.cannotafford")));
            }
        }
        if (((FluidTradeData)this.trade).isSale() && !context.canFitFluid(((FluidTradeData)this.trade).productOfQuantity()) && !this.allowsDrainage(context)) {
            alerts.add(AlertData.warn((MutableComponent)Component.m_237115_((String)"tooltip.lightmanscurrency.nooutputcontainer")));
        }
    }

    private List<TradeButton.DisplayEntry> getFluidEntry(TradeContext context) {
        ArrayList<TradeButton.DisplayEntry> entries = new ArrayList<TradeButton.DisplayEntry>();
        if (!((FluidTradeData)this.trade).getProduct().isEmpty()) {
            entries.add(TradeButton.DisplayEntry.of((ItemStack)((FluidTradeData)this.trade).getFilledBucket(), (int)((FluidTradeData)this.trade).getBucketQuantity(), this.getFluidTooltip(context)));
        } else if (context.isStorageMode) {
            entries.add(TradeButton.DisplayEntry.of(FluidInputSlot.BACKGROUND, (List)Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"tooltip.lctech.trader.fluid_edit")})));
        }
        if (this.allowsDrainage(context)) {
            entries.add(SpriteDisplayEntry.of(FluidStorageClientTab.GUI_TEXTURE, 0, 0, 8, 8, Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"tooltip.lctech.trader.fluid_settings.drainable")})));
        }
        return entries;
    }

    private List<Component> getFluidTooltip(TradeContext context) {
        if (((FluidTradeData)this.trade).getProduct().isEmpty()) {
            return null;
        }
        ArrayList tooltips = Lists.newArrayList();
        tooltips.add(EasyText.translatable((String)("gui.lctech.fluidtrade.tooltip." + ((FluidTradeData)this.trade).getTradeDirection().name().toLowerCase()), (Object[])new Object[]{FluidFormatUtil.getFluidName(((FluidTradeData)this.trade).getProduct(), ChatFormatting.GOLD)}));
        tooltips.add(EasyText.translatable((String)"gui.lctech.fluidtrade.tooltip.quantity", (Object[])new Object[]{((FluidTradeData)this.trade).getBucketQuantity(), FluidFormatUtil.formatFluidAmount(((FluidTradeData)this.trade).getQuantity())}).m_130940_(ChatFormatting.GOLD));
        if (context.hasTrader()) {
            tooltips.add(EasyText.translatable((String)"tooltip.lightmanscurrency.trader.stock", (Object[])new Object[]{context.getTrader().isCreative() ? Component.m_237115_((String)"tooltip.lightmanscurrency.trader.stock.infinite").m_130940_(ChatFormatting.GOLD) : Component.m_237113_((String)String.valueOf(((FluidTradeData)this.trade).getStock(context))).m_130940_(ChatFormatting.GOLD)}));
        }
        return tooltips;
    }

    private boolean allowsDrainage(TradeContext context) {
        if (context.isStorageMode || !((FluidTradeData)this.trade).isSale()) {
            return false;
        }
        TraderData traderData = context.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            return trader.drainCapable() && trader.hasOutputSide() && trader.getStorage().isDrainable(((FluidTradeData)this.trade).getProduct());
        }
        return false;
    }
}

