/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.fluid.tradedata;

import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.client.FluidTradeButtonRenderer;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison.ProductComparisonResult;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidTradeData
extends TradeData {
    FluidStack product = FluidStack.EMPTY;
    int bucketQuantity = 1;
    TradeData.TradeDirection tradeDirection = TradeData.TradeDirection.SALE;

    public FluidStack getProduct() {
        return this.product.copy();
    }

    public void setProduct(FluidStack newProduct) {
        this.product = newProduct.copy();
        if (this.product.getFluid() != Fluids.f_76191_) {
            this.product.setAmount(1000);
        }
    }

    public FluidStack productOfQuantity() {
        FluidStack stack = this.product.copy();
        if (!stack.isEmpty()) {
            stack.setAmount(this.getQuantity());
        }
        return stack;
    }

    public int getQuantity() {
        return this.bucketQuantity * 1000;
    }

    public int getBucketQuantity() {
        return this.bucketQuantity;
    }

    public void setBucketQuantity(int value) {
        this.bucketQuantity = MathUtil.clamp((int)value, (int)1, (int)this.getMaxBucketQuantity());
    }

    public int getMaxBucketQuantity() {
        return Math.max(1, (Integer)TechConfig.SERVER.fluidTradeMaxQuantity.get());
    }

    public TradeData.TradeDirection getTradeDirection() {
        return this.tradeDirection;
    }

    public void setTradeDirection(TradeData.TradeDirection type) {
        this.tradeDirection = type;
    }

    public boolean isSale() {
        return this.tradeDirection == TradeData.TradeDirection.SALE;
    }

    public boolean isPurchase() {
        return this.tradeDirection == TradeData.TradeDirection.PURCHASE;
    }

    public ItemStack getFilledBucket() {
        return FluidUtil.getFilledBucket((FluidStack)this.product);
    }

    public FluidTradeData(boolean validateRules) {
        super(validateRules);
    }

    public boolean hasStock(FluidTraderData trader) {
        return this.getStock(trader) > 0;
    }

    public boolean hasStock(TradeContext context) {
        return this.getStock(context) > 0;
    }

    public int getStock(FluidTraderData trader) {
        if (this.product.isEmpty()) {
            return 0;
        }
        if (this.isSale()) {
            return trader.getStorage().getAvailableFluidCount(this.product) / this.getQuantity();
        }
        if (this.isPurchase()) {
            return this.stockCountOfCost((TraderData)trader);
        }
        return 0;
    }

    public int getStock(TradeContext context) {
        TraderData traderData;
        if (this.product.isEmpty()) {
            return 0;
        }
        if (!context.hasTrader() || !((traderData = context.getTrader()) instanceof FluidTraderData)) {
            return 0;
        }
        FluidTraderData trader = (FluidTraderData)traderData;
        if (trader.isCreative()) {
            return 1;
        }
        if (this.isSale()) {
            return trader.getStorage().getAvailableFluidCount(this.product) / this.getQuantity();
        }
        if (this.isPurchase()) {
            return this.stockCountOfCost(context);
        }
        return 0;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isSale()) {
            return context.hasFunds(this.getCost(context));
        }
        if (this.isPurchase()) {
            return context.hasFluid(this.productOfQuantity());
        }
        return false;
    }

    public boolean hasSpace(FluidTraderData trader) {
        if (this.isPurchase()) {
            return trader.getStorage().getFillableAmount(this.product) >= this.getQuantity();
        }
        return true;
    }

    public boolean isValid() {
        return super.isValid() && !this.product.isEmpty();
    }

    public CompoundTag getAsNBT() {
        CompoundTag compound = super.getAsNBT();
        compound.m_128365_("Trade", (Tag)this.product.writeToNBT(new CompoundTag()));
        compound.m_128405_("Quantity", this.bucketQuantity);
        compound.m_128359_("TradeType", this.tradeDirection.name());
        return compound;
    }

    public void loadFromNBT(CompoundTag compound) {
        super.loadFromNBT(compound);
        this.product = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("Trade"));
        if (compound.m_128425_("Quantity", 3)) {
            this.bucketQuantity = compound.m_128451_("Quantity");
        }
        this.tradeDirection = FluidTradeData.loadTradeType(compound.m_128461_("TradeType"));
    }

    public static TradeData.TradeDirection loadTradeType(String name) {
        try {
            return TradeData.TradeDirection.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            LCTech.LOGGER.error("Could not load '" + name + "' as a TradeType.");
            return TradeData.TradeDirection.SALE;
        }
    }

    public static List<FluidTradeData> listOfSize(int tradeCount, boolean validateRules) {
        ArrayList<FluidTradeData> list = new ArrayList<FluidTradeData>();
        while (list.size() < tradeCount) {
            list.add(new FluidTradeData(validateRules));
        }
        return list;
    }

    public static void WriteNBTList(List<FluidTradeData> tradeList, CompoundTag compound) {
        FluidTradeData.WriteNBTList(tradeList, compound, "Trades");
    }

    public static void WriteNBTList(List<FluidTradeData> tradeList, CompoundTag compound, String tag) {
        ListTag list = new ListTag();
        for (FluidTradeData fluidTradeData : tradeList) {
            list.add((Object)fluidTradeData.getAsNBT());
        }
        compound.m_128365_(tag, (Tag)list);
    }

    public static List<FluidTradeData> LoadNBTList(CompoundTag compound, boolean validateRules) {
        return FluidTradeData.LoadNBTList(compound, "Trades", validateRules);
    }

    public static List<FluidTradeData> LoadNBTList(CompoundTag compound, String tag, boolean validateRules) {
        if (!compound.m_128441_(tag)) {
            return FluidTradeData.listOfSize(1, validateRules);
        }
        ListTag list = compound.m_128437_(tag, 10);
        ArrayList<FluidTradeData> tradeData = new ArrayList<FluidTradeData>();
        for (int i = 0; i < list.size(); ++i) {
            tradeData.add(FluidTradeData.loadData(list.m_128728_(i), validateRules));
        }
        return tradeData;
    }

    public static FluidTradeData loadData(CompoundTag compound, boolean validateRules) {
        FluidTradeData trade = new FluidTradeData(validateRules);
        trade.loadFromNBT(compound);
        return trade;
    }

    public TradeComparisonResult compare(TradeData otherTrade) {
        TradeComparisonResult result = new TradeComparisonResult();
        if (otherTrade instanceof FluidTradeData) {
            FluidTradeData otherFluidTrade = (FluidTradeData)otherTrade;
            result.setCompatible();
            result.addProductResult(ProductComparisonResult.CompareFluid((FluidStack)this.productOfQuantity(), (FluidStack)otherFluidTrade.productOfQuantity()));
            result.setPriceResult(this.getCost().getValueNumber() - otherTrade.getCost().getValueNumber());
            result.setTypeResult(this.tradeDirection == otherFluidTrade.tradeDirection);
        }
        return result;
    }

    public boolean AcceptableDifferences(TradeComparisonResult result) {
        if (!result.TypeMatches() || !result.isCompatible()) {
            return false;
        }
        if (result.getProductResultCount() <= 0) {
            return false;
        }
        ProductComparisonResult productResult = result.getProductResult(0);
        if (productResult.SameProductType() && productResult.SameProductNBT()) {
            if (this.isSale() ? productResult.ProductQuantityDifference() > 0 : this.isPurchase() && productResult.ProductQuantityDifference() < 0) {
                return false;
            }
        } else {
            return false;
        }
        if (this.isSale() && result.isPriceExpensive()) {
            return false;
        }
        return !this.isPurchase() || !result.isPriceCheaper();
    }

    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!differences.PriceMatches()) {
            long difference = differences.priceDifference();
            if (difference < 0L) {
                list.add((Component)EasyText.translatable((String)"gui.lightmanscurrency.interface.difference.expensive", (Object[])new Object[]{MoneyUtil.getStringOfValue((long)(-difference))}).m_130940_(ChatFormatting.RED));
            } else {
                list.add((Component)EasyText.translatable((String)"gui.lightmanscurrency.interface.difference.cheaper", (Object[])new Object[]{MoneyUtil.getStringOfValue((long)difference)}).m_130940_(ChatFormatting.RED));
            }
        }
        if (differences.getProductResultCount() > 0) {
            MutableComponent directionName = this.isSale() ? EasyText.translatable((String)"gui.lctech.interface.difference.product.sale", (Object[])new Object[0]) : EasyText.translatable((String)"gui.lctech.interface.difference.product.purchase", (Object[])new Object[0]);
            ProductComparisonResult productCheck = differences.getProductResult(0);
            if (!productCheck.SameProductType()) {
                list.add((Component)EasyText.translatable((String)"gui.lctech.interface.fluid.difference.fluidtype", (Object[])new Object[]{directionName}).m_130940_(ChatFormatting.RED));
            } else if (!productCheck.SameProductNBT()) {
                list.add((Component)EasyText.translatable((String)"gui.lctech.interface.fluid.difference.fluidnbt", (Object[])new Object[0]));
            } else if (!productCheck.SameProductQuantity()) {
                int quantityDifference = productCheck.ProductQuantityDifference();
                if (quantityDifference < 0) {
                    list.add((Component)EasyText.translatable((String)"gui.lctech.interface.fluid.difference.quantity.more", (Object[])new Object[]{directionName, FluidFormatUtil.formatFluidAmount(-quantityDifference)}).m_130940_(ChatFormatting.RED));
                } else {
                    list.add((Component)EasyText.translatable((String)"gui.lctech.interface.fluid.difference.quantity.less", (Object[])new Object[]{directionName, FluidFormatUtil.formatFluidAmount(quantityDifference)}).m_130940_(ChatFormatting.RED));
                }
            }
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new FluidTradeButtonRenderer(this);
    }

    public void onInputDisplayInteraction(BasicTradeEditTab tab, @Nullable Consumer<CompoundTag> clientMessage, int index, int button, @Nonnull ItemStack heldItem) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            int tradeIndex = trader.getTradeData().indexOf((Object)this);
            if (tradeIndex < 0) {
                return;
            }
            if (this.isSale()) {
                CompoundTag extraData = new CompoundTag();
                extraData.m_128405_("TradeIndex", tradeIndex);
                extraData.m_128405_("StartingSlot", -1);
                tab.sendOpenTabMessage(2, extraData);
            }
            if (this.isPurchase() && this.onProductInteraction(tab, tradeIndex, trader, heldItem)) {
                tab.sendInputInteractionMessage(tradeIndex, index, button, heldItem);
            }
        }
    }

    public void onOutputDisplayInteraction(BasicTradeEditTab tab, @Nullable Consumer<CompoundTag> clientHandler, int index, int button, @Nonnull ItemStack heldItem) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            int tradeIndex = trader.getTradeData().indexOf((Object)this);
            if (tradeIndex < 0) {
                return;
            }
            if (this.isSale()) {
                if (this.onProductInteraction(tab, tradeIndex, trader, heldItem)) {
                    tab.sendOutputInteractionMessage(tradeIndex, index, button, heldItem);
                }
            } else if (this.isPurchase()) {
                CompoundTag extraData = new CompoundTag();
                extraData.m_128405_("TradeIndex", tradeIndex);
                extraData.m_128405_("StartingSlot", -1);
                tab.sendOpenTabMessage(2, extraData);
            }
        }
    }

    private boolean onProductInteraction(BasicTradeEditTab tab, int tradeIndex, FluidTraderData trader, ItemStack heldItem) {
        if (heldItem.m_41619_() && this.product.isEmpty()) {
            CompoundTag extraData = new CompoundTag();
            extraData.m_128405_("TradeIndex", tradeIndex);
            extraData.m_128405_("StartingSlot", 0);
            tab.sendOpenTabMessage(2, extraData);
            return false;
        }
        FluidStack heldFluid = FluidUtil.getFluidContained((ItemStack)heldItem).orElse(FluidStack.EMPTY);
        if (!heldFluid.isEmpty()) {
            this.setProduct(heldFluid);
            trader.markTradesDirty();
            if (trader.getStorage().refactorTanks()) {
                trader.markStorageDirty();
            }
            LCTech.LOGGER.debug("Set Fluid from held stack on the " + DebugUtil.getSideText((boolean)tab.menu.isClient()));
        } else if (!this.product.isEmpty()) {
            this.setProduct(FluidStack.EMPTY);
            trader.markTradesDirty();
            if (trader.getStorage().refactorTanks()) {
                trader.markStorageDirty();
            }
            LCTech.LOGGER.debug("Cleared Fluid on the " + DebugUtil.getSideText((boolean)tab.menu.isClient()));
        } else {
            LCTech.LOGGER.debug("Doing nothing as both the held Fluid and the current Product are empty on the " + DebugUtil.getSideText((boolean)tab.menu.isClient()));
        }
        return tab.menu.isClient();
    }

    public void onInteraction(@Nonnull BasicTradeEditTab tab, @Nullable Consumer<CompoundTag> clientHandler, int mouseX, int mouseY, int button, @Nonnull ItemStack heldItem) {
    }
}

