/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.fluid;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.common.items.FluidShardItem;
import io.github.lightman314.lctech.common.menu.traderstorage.fluid.FluidStorageTab;
import io.github.lightman314.lctech.common.menu.traderstorage.fluid.FluidTradeEditTab;
import io.github.lightman314.lctech.common.notifications.types.FluidTradeNotification;
import io.github.lightman314.lctech.common.traders.fluid.FluidInteractionSlot;
import io.github.lightman314.lctech.common.traders.fluid.TradeFluidHandler;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.upgrades.TechUpgradeTypes;
import io.github.lightman314.lctech.common.util.FluidItemUtil;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidTraderData
extends InputTraderData
implements TraderFluidStorage.ITraderFluidFilter {
    public static final ResourceLocation TYPE = new ResourceLocation("lctech", "fluid_trader");
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{TechUpgradeTypes.FLUID_CAPACITY});
    public final TradeFluidHandler fluidHandler = new TradeFluidHandler(this);
    TraderFluidStorage storage = new TraderFluidStorage(this);
    List<FluidTradeData> trades = FluidTradeData.listOfSize(1, true);

    public TraderFluidStorage getStorage() {
        return this.storage;
    }

    public void markStorageDirty() {
        this.markDirty(new Consumer[]{this::saveStorage});
    }

    public final boolean drainCapable() {
        return !this.showOnTerminal();
    }

    public FluidTraderData() {
        super(TYPE);
    }

    public FluidTraderData(int tradeCount, Level level, BlockPos pos) {
        super(TYPE, level, pos);
        this.trades = FluidTradeData.listOfSize(tradeCount, true);
    }

    protected void loadAdditional(CompoundTag compound) {
        super.loadAdditional(compound);
        if (compound.m_128425_("Trades", 9)) {
            this.trades = FluidTradeData.LoadNBTList(compound, !this.isPersistent());
        }
        if (compound.m_128441_("FluidStorage")) {
            this.storage.load(compound, "FluidStorage");
        }
    }

    protected void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        this.saveTrades(compound);
        this.saveStorage(compound);
    }

    protected final void saveTrades(CompoundTag compound) {
        FluidTradeData.WriteNBTList(this.trades, compound);
    }

    protected final void saveStorage(CompoundTag compound) {
        this.storage.save(compound, "FluidStorage");
    }

    public int getTradeCount() {
        return this.trades.size();
    }

    public void addTrade(Player requester) {
        if (this.getTradeCount() >= 100) {
            return;
        }
        if (!CommandLCAdmin.isAdminPlayer((Player)requester)) {
            Permissions.PermissionWarning((Player)requester, (String)"add trade slot", (String)"LC_ADMIN_MODE");
            return;
        }
        this.overrideTradeCount(this.getTradeCount() + 1);
    }

    public void removeTrade(Player requester) {
        if (this.getTradeCount() <= 1) {
            return;
        }
        if (!CommandLCAdmin.isAdminPlayer((Player)requester)) {
            Permissions.PermissionWarning((Player)requester, (String)"remove trade slot", (String)"LC_ADMIN_MODE");
            return;
        }
        this.overrideTradeCount(this.getTradeCount() - 1);
    }

    public void overrideTradeCount(int newTradeCount) {
        if (this.getTradeCount() == newTradeCount) {
            return;
        }
        int tradeCount = MathUtil.clamp((int)newTradeCount, (int)1, (int)100);
        List<FluidTradeData> oldTrades = this.trades;
        this.trades = FluidTradeData.listOfSize(tradeCount, !this.isPersistent());
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        this.markTradesDirty();
    }

    public FluidTradeData getTrade(int tradeIndex) {
        if (tradeIndex >= 0 && tradeIndex < this.trades.size()) {
            return this.trades.get(tradeIndex);
        }
        return new FluidTradeData(false);
    }

    public int getTradeStock(int index) {
        return this.getTrade(index).getStock(this);
    }

    @Nonnull
    public List<FluidTradeData> getTradeData() {
        return new ArrayList<FluidTradeData>(this.trades);
    }

    public TradeFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public List<FluidStack> getRelevantFluids() {
        ArrayList<FluidStack> result = new ArrayList<FluidStack>();
        for (FluidTradeData trade : this.getTradeData()) {
            FluidStack product = trade.getProduct();
            if (product.isEmpty() || this.isInList(result, product)) continue;
            result.add(product);
        }
        return result;
    }

    private boolean isInList(List<FluidStack> list, FluidStack fluid) {
        if (fluid.isEmpty()) {
            return true;
        }
        for (FluidStack query : list) {
            if (!query.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    public static int getDefaultTankCapacity() {
        return (Integer)TechConfig.SERVER.fluidTraderDefaultStorage.get() * 1000;
    }

    @Override
    public int getTankCapacity() {
        int defaultCapacity;
        int tankCapacity = defaultCapacity = FluidTraderData.getDefaultTankCapacity();
        boolean baseStorageCompensation = false;
        for (int i = 0; i < this.getUpgrades().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            int addAmount = upgradeItem.getDefaultUpgradeData().getIntValue(CapacityUpgrade.CAPACITY);
            if (addAmount > defaultCapacity && !baseStorageCompensation) {
                addAmount -= defaultCapacity;
                baseStorageCompensation = true;
            }
            tankCapacity += addAmount;
        }
        return tankCapacity;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction relativeSide) {
        return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> this.getFluidHandler().getExternalHandler(relativeSide)));
    }

    public IconData inputSettingsTabIcon() {
        return IconData.of((ItemLike)Items.f_42447_);
    }

    public MutableComponent inputSettingsTabTooltip() {
        return Component.m_237115_((String)"tooltip.lctech.settings.fluidinput");
    }

    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        FluidTradeData trade = this.getTrade(tradeIndex);
        if (trade == null || !trade.isValid()) {
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!context.hasPlayerReference()) {
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (this.runPreTradeEvent(context.getPlayerReference(), trade).isCanceled()) {
            return TradeContext.TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        CoinValue price = this.runTradeCostEvent(context.getPlayerReference(), trade).getCostResult();
        if (!trade.hasStock(context) && !this.isCreative()) {
            return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
        }
        if (trade.isSale()) {
            TraderFluidStorage.FluidEntry tankEntry = this.getStorage().getTank(trade.getProduct());
            if (!(context.canFitFluid(trade.productOfQuantity()) || this.hasOutputSide() && tankEntry != null && tankEntry.drainable)) {
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.getPayment(price)) {
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            boolean drainTank = true;
            if (context.canFitFluid(trade.productOfQuantity())) {
                context.fillFluid(trade.productOfQuantity());
            } else {
                drainTank = false;
                tankEntry.addPendingDrain(trade.getQuantity());
                this.markStorageDirty();
            }
            CoinValue taxesPaid = CoinValue.EMPTY;
            if (!this.isCreative()) {
                if (drainTank) {
                    this.getStorage().drain(trade.productOfQuantity());
                    this.markStorageDirty();
                }
                taxesPaid = this.addStoredMoney(price, true);
            }
            this.pushNotification(FluidTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(context.getPlayerReference(), trade, price, taxesPaid);
            return TradeContext.TradeResult.SUCCESS;
        }
        if (trade.isPurchase()) {
            if (!context.hasFluid(trade.productOfQuantity())) {
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this) && !this.isCreative()) {
                return TradeContext.TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!context.givePayment(price)) {
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.drainFluid(trade.productOfQuantity())) {
                context.getPayment(price);
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            CoinValue taxesPaid = CoinValue.EMPTY;
            if (!this.isCreative()) {
                this.getStorage().forceFillTank(trade.productOfQuantity());
                this.markStorageDirty();
                taxesPaid = this.removeStoredMoney(price, true);
            }
            this.pushNotification(FluidTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(context.getPlayerReference(), trade, price, taxesPaid);
            return TradeContext.TradeResult.SUCCESS;
        }
        return TradeContext.TradeResult.FAIL_INVALID_TRADE;
    }

    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
        interactionSlots.add(FluidInteractionSlot.INSTANCE);
    }

    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    public boolean canMakePersistent() {
        return true;
    }

    protected void getAdditionalContents(List<ItemStack> results) {
        for (TraderFluidStorage.FluidEntry entry : this.storage.getContents()) {
            if (entry.getTankContents().isEmpty()) continue;
            results.add(FluidShardItem.GetFluidShard(entry.getTankContents()));
        }
    }

    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42447_);
    }

    public boolean hasValidTrade() {
        for (FluidTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            return true;
        }
        return false;
    }

    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(1, (TraderStorageTab)new FluidStorageTab(menu));
        menu.setTab(2, (TraderStorageTab)new FluidTradeEditTab(menu));
    }

    protected void loadAdditionalFromJson(JsonObject json) throws Exception {
        if (!json.has("Trades")) {
            throw new Exception("Fluid Trader must have a trade list.");
        }
        JsonArray tradeList = json.get("Trades").getAsJsonArray();
        this.trades = new ArrayList<FluidTradeData>();
        for (int i = 0; i < tradeList.size() && this.trades.size() < 100; ++i) {
            try {
                JsonObject tradeData = tradeList.get(i).getAsJsonObject();
                FluidTradeData newTrade = new FluidTradeData(false);
                JsonObject product = tradeData.get("Product").getAsJsonObject();
                newTrade.setProduct(FluidItemUtil.parseFluidStack(product));
                if (tradeData.has("TradeType")) {
                    newTrade.setTradeDirection(FluidTradeData.loadTradeType(tradeData.get("TradeType").getAsString()));
                }
                newTrade.setCost(CoinValue.Parse((JsonElement)tradeData.get("Price")));
                if (tradeData.has("Quantity")) {
                    newTrade.setBucketQuantity(tradeData.get("Quantity").getAsInt());
                }
                if (tradeData.has("TradeRules")) {
                    newTrade.setRules(TradeRule.Parse((JsonArray)tradeData.get("TradeRules").getAsJsonArray(), (ITradeRuleHost)newTrade));
                }
                this.trades.add(newTrade);
                continue;
            }
            catch (Exception e) {
                LCTech.LOGGER.error("Error parsing fluid trade at index " + i, (Throwable)e);
            }
        }
        if (this.trades.size() == 0) {
            throw new Exception("Trader has no valid trades!");
        }
    }

    protected void saveAdditionalToJson(JsonObject json) {
        JsonArray trades = new JsonArray();
        for (FluidTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            JsonObject tradeData = new JsonObject();
            tradeData.addProperty("TradeType", trade.getTradeDirection().name());
            tradeData.add("Price", (JsonElement)trade.getCost().toJson());
            tradeData.add("Product", (JsonElement)FluidItemUtil.convertFluidStack(trade.getProduct()));
            tradeData.addProperty("Quantity", (Number)trade.getBucketQuantity());
            if (trade.getRules().size() > 0) {
                tradeData.add("TradeRules", (JsonElement)TradeRule.saveRulesToJson((List)trade.getRules()));
            }
            trades.add((JsonElement)tradeData);
        }
        json.add("Trades", (JsonElement)trades);
    }

    protected void saveAdditionalPersistentData(CompoundTag compound) {
        ListTag tradePersistentData = new ListTag();
        boolean tradesAreRelevant = false;
        Iterator<FluidTradeData> iterator = this.trades.iterator();
        while (iterator.hasNext()) {
            CompoundTag ptTag = new CompoundTag();
            FluidTradeData trade = iterator.next();
            if (TradeRule.savePersistentData((CompoundTag)ptTag, (List)trade.getRules(), (String)"RuleData")) {
                tradesAreRelevant = true;
            }
            tradePersistentData.add((Object)ptTag);
        }
        if (tradesAreRelevant) {
            compound.m_128365_("PersistentTradeData", (Tag)tradePersistentData);
        }
    }

    protected void loadAdditionalPersistentData(CompoundTag compound) {
        if (compound.m_128441_("PersistentTradeData")) {
            ListTag tradePersistentData = compound.m_128437_("PersistentTradeData", 10);
            for (int i = 0; i < tradePersistentData.size() && i < this.trades.size(); ++i) {
                FluidTradeData trade = this.trades.get(i);
                CompoundTag ptTag = tradePersistentData.m_128728_(i);
                TradeRule.loadPersistentData((CompoundTag)ptTag, (List)trade.getRules(), (String)"RuleData");
            }
        }
    }
}

