/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.energy.tradedata;

import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.energy.tradedata.client.EnergyTradeButtonRenderer;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison.ProductComparisonResult;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison.TradeComparisonResult;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnergyTradeData
extends TradeData {
    int amount = 0;
    TradeData.TradeDirection tradeDirection = TradeData.TradeDirection.SALE;

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int newAmount) {
        this.amount = Math.max(0, newAmount);
    }

    public TradeData.TradeDirection getTradeDirection() {
        return this.tradeDirection;
    }

    public void setTradeDirection(TradeData.TradeDirection direction) {
        this.tradeDirection = direction;
    }

    public boolean isSale() {
        return this.tradeDirection == TradeData.TradeDirection.SALE;
    }

    public boolean isPurchase() {
        return this.tradeDirection == TradeData.TradeDirection.PURCHASE;
    }

    public EnergyTradeData(boolean validateRules) {
        super(validateRules);
    }

    public boolean hasStock(EnergyTraderData trader) {
        return this.getStock(trader) > 0;
    }

    public boolean hasStock(TradeContext context) {
        return this.getStock(context) > 0;
    }

    public int getStock(EnergyTraderData trader) {
        if (this.amount <= 0) {
            return 0;
        }
        if (this.isSale()) {
            return trader.getAvailableEnergy() / this.amount;
        }
        if (this.isPurchase()) {
            return this.stockCountOfCost((TraderData)trader);
        }
        return 0;
    }

    public int getStock(TradeContext context) {
        TraderData traderData;
        if (this.amount <= 0) {
            return 0;
        }
        if (!context.hasTrader() || !((traderData = context.getTrader()) instanceof EnergyTraderData)) {
            return 0;
        }
        EnergyTraderData trader = (EnergyTraderData)traderData;
        if (trader.isCreative()) {
            return 1;
        }
        if (this.isSale()) {
            return trader.getAvailableEnergy() / this.amount;
        }
        if (this.isPurchase()) {
            return this.stockCountOfCost(context);
        }
        return 0;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isSale()) {
            return context.hasFunds(this.getCost(context));
        }
        if (this.isPurchase()) {
            return context.hasEnergy(this.amount);
        }
        return false;
    }

    public boolean hasSpace(EnergyTraderData trader) {
        if (this.isPurchase()) {
            return trader.getMaxEnergy() - trader.getTotalEnergy() >= this.amount;
        }
        return true;
    }

    public boolean isValid() {
        return super.isValid() && this.amount > 0;
    }

    public CompoundTag getAsNBT() {
        CompoundTag compound = super.getAsNBT();
        compound.m_128405_("Amount", this.amount);
        compound.m_128359_("TradeType", this.tradeDirection.name());
        return compound;
    }

    public void loadFromNBT(CompoundTag compound) {
        super.loadFromNBT(compound);
        this.amount = compound.m_128451_("Amount");
        this.tradeDirection = EnergyTradeData.loadTradeType(compound.m_128461_("TradeType"));
    }

    public static TradeData.TradeDirection loadTradeType(String name) {
        try {
            return TradeData.TradeDirection.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            LCTech.LOGGER.error("Could not load '" + name + "' as a TradeType.");
            return TradeData.TradeDirection.SALE;
        }
    }

    public static List<EnergyTradeData> listOfSize(int tradeCount, boolean validateRules) {
        ArrayList<EnergyTradeData> list = new ArrayList<EnergyTradeData>();
        while (list.size() < tradeCount) {
            list.add(new EnergyTradeData(validateRules));
        }
        return list;
    }

    public static void WriteNBTList(List<EnergyTradeData> tradeList, CompoundTag compound) {
        EnergyTradeData.WriteNBTList(tradeList, compound, "Trades");
    }

    public static void WriteNBTList(List<EnergyTradeData> tradeList, CompoundTag compound, String tag) {
        ListTag list = new ListTag();
        for (EnergyTradeData energyTradeData : tradeList) {
            list.add((Object)energyTradeData.getAsNBT());
        }
        compound.m_128365_(tag, (Tag)list);
    }

    public static List<EnergyTradeData> LoadNBTList(CompoundTag compound, boolean validateRules) {
        return EnergyTradeData.LoadNBTList(compound, "Trades", validateRules);
    }

    public static List<EnergyTradeData> LoadNBTList(CompoundTag compound, String tag, boolean validateRules) {
        if (!compound.m_128441_(tag)) {
            return EnergyTradeData.listOfSize(1, validateRules);
        }
        ArrayList<EnergyTradeData> tradeData = new ArrayList<EnergyTradeData>();
        ListTag list = compound.m_128437_(tag, 10);
        for (int i = 0; i < list.size(); ++i) {
            tradeData.add(EnergyTradeData.loadData(list.m_128728_(i), validateRules));
        }
        return tradeData;
    }

    public static EnergyTradeData loadData(CompoundTag compound, boolean validateRules) {
        EnergyTradeData trade = new EnergyTradeData(validateRules);
        trade.loadFromNBT(compound);
        return trade;
    }

    public TradeComparisonResult compare(TradeData otherTrade) {
        TradeComparisonResult result = new TradeComparisonResult();
        if (otherTrade instanceof EnergyTradeData) {
            EnergyTradeData otherEnergyTrade = (EnergyTradeData)otherTrade;
            result.setCompatible();
            result.addProductResult(ProductComparisonResult.CompareEnergy((int)this.getAmount(), (int)otherEnergyTrade.getAmount()));
            result.setPriceResult(this.getCost().getValueNumber() - otherTrade.getCost().getValueNumber());
            result.setTypeResult(this.tradeDirection == otherEnergyTrade.tradeDirection);
        }
        return result;
    }

    public boolean AcceptableDifferences(TradeComparisonResult result) {
        if (!result.TypeMatches() || !result.isCompatible()) {
            return false;
        }
        if (result.getProductResultCount() <= 0) {
            return false;
        }
        ProductComparisonResult productResult = result.getProductResult(0);
        if (productResult.SameProductType() && productResult.SameProductNBT()) {
            if (this.isSale() ? productResult.ProductQuantityDifference() > 0 : this.isPurchase() && productResult.ProductQuantityDifference() < 0) {
                return false;
            }
        } else {
            return false;
        }
        if (this.isSale() && result.isPriceExpensive()) {
            return false;
        }
        return !this.isPurchase() || !result.isPriceCheaper();
    }

    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!differences.PriceMatches()) {
            long difference = differences.priceDifference();
            if (difference < 0L) {
                list.add((Component)Component.m_237110_((String)"gui.lightmanscurrency.interface.difference.expensive", (Object[])new Object[]{MoneyUtil.getStringOfValue((long)(-difference))}).m_130940_(ChatFormatting.RED));
            } else {
                list.add((Component)Component.m_237110_((String)"gui.lightmanscurrency.interface.difference.cheaper", (Object[])new Object[]{MoneyUtil.getStringOfValue((long)difference)}).m_130940_(ChatFormatting.RED));
            }
        }
        if (differences.getProductResultCount() > 0) {
            MutableComponent directionName = this.isSale() ? Component.m_237115_((String)"gui.lctech.interface.difference.product.sale") : Component.m_237115_((String)"gui.lctech.interface.difference.product.purchase");
            ProductComparisonResult productCheck = differences.getProductResult(0);
            if (!productCheck.SameProductType()) {
                list.add((Component)Component.m_237110_((String)"gui.lctech.interface.fluid.difference.fluidtype", (Object[])new Object[]{directionName}).m_130940_(ChatFormatting.RED));
            }
            if (!productCheck.SameProductQuantity()) {
                int quantityDifference = productCheck.ProductQuantityDifference();
                if (quantityDifference < 0) {
                    list.add((Component)Component.m_237110_((String)"gui.lctech.interface.energy.difference.quantity.more", (Object[])new Object[]{directionName, EnergyUtil.formatEnergyAmount(-quantityDifference)}).m_130940_(ChatFormatting.RED));
                } else {
                    list.add((Component)Component.m_237110_((String)"gui.lctech.interface.energy.difference.quantity.less", (Object[])new Object[]{directionName, EnergyUtil.formatEnergyAmount(quantityDifference)}).m_130940_(ChatFormatting.RED));
                }
            }
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new EnergyTradeButtonRenderer(this);
    }

    public void onInputDisplayInteraction(BasicTradeEditTab tab, @Nullable Consumer<CompoundTag> clientMessage, int index, int button, @Nonnull ItemStack heldItem) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof EnergyTraderData) {
            EnergyTraderData trader = (EnergyTraderData)traderData;
            int tradeIndex = trader.getTradeData().indexOf((Object)this);
            if (tradeIndex < 0) {
                return;
            }
            int openSlot = this.isSale() ? -1 : 0;
            CompoundTag extraData = new CompoundTag();
            extraData.m_128405_("TradeIndex", tradeIndex);
            extraData.m_128405_("StartingSlot", openSlot);
            tab.sendOpenTabMessage(2, extraData);
        }
    }

    public void onOutputDisplayInteraction(BasicTradeEditTab tab, @Nullable Consumer<CompoundTag> clientMessage, int index, int button, @Nonnull ItemStack heldItem) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof EnergyTraderData) {
            EnergyTraderData trader = (EnergyTraderData)traderData;
            int tradeIndex = trader.getTradeData().indexOf((Object)this);
            if (tradeIndex < 0) {
                return;
            }
            int openSlot = this.isSale() ? 0 : -1;
            CompoundTag extraData = new CompoundTag();
            extraData.m_128405_("TradeIndex", tradeIndex);
            extraData.m_128405_("StartingSlot", openSlot);
            tab.sendOpenTabMessage(2, extraData);
        }
    }

    public void onInteraction(@Nonnull BasicTradeEditTab tab, @Nullable Consumer<CompoundTag> clientMessage, int mouseX, int mouseY, int button, @Nonnull ItemStack heldItem) {
    }
}

