/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.energy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.client.gui.settings.energy.EnergyInputAddon;
import io.github.lightman314.lctech.common.core.ModItems;
import io.github.lightman314.lctech.common.items.IBatteryItem;
import io.github.lightman314.lctech.common.menu.traderstorage.energy.EnergyStorageTab;
import io.github.lightman314.lctech.common.menu.traderstorage.energy.EnergyTradeEditTab;
import io.github.lightman314.lctech.common.notifications.types.EnergyTradeNotification;
import io.github.lightman314.lctech.common.traders.energy.EnergyInteractionSlot;
import io.github.lightman314.lctech.common.traders.energy.TradeEnergyHandler;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lctech.common.upgrades.TechUpgradeTypes;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.input.InputTabAddon;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class EnergyTraderData
extends InputTraderData {
    public static final int DEFAULT_TRADE_LIMIT = 8;
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{TechUpgradeTypes.ENERGY_CAPACITY});
    public static final ResourceLocation TYPE = new ResourceLocation("lctech", "energy_trader");
    protected final TradeEnergyHandler energyHandler = new TradeEnergyHandler(this);
    private DrainMode drainMode = DrainMode.PURCHASES_ONLY;
    List<EnergyTradeData> trades = EnergyTradeData.listOfSize(1, true);
    int energyStorage = 0;
    int pendingDrain = 0;

    public final boolean drainCapable() {
        return !this.showOnTerminal();
    }

    public DrainMode getDrainMode() {
        return this.drainMode;
    }

    public boolean isAlwaysDrainMode() {
        return !this.drainCapable() || this.drainMode == DrainMode.ALWAYS;
    }

    public boolean isPurchaseDrainMode() {
        if (!this.drainCapable()) {
            return false;
        }
        if (this.drainMode == DrainMode.PURCHASES_ONLY) {
            for (Direction side : Direction.values()) {
                if (!this.allowOutputSide(side)) continue;
                return true;
            }
        }
        return false;
    }

    public EnergyTraderData() {
        super(TYPE);
    }

    public EnergyTraderData(Level level, BlockPos pos) {
        super(TYPE, level, pos);
    }

    public void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        this.saveTrades(compound);
        this.saveEnergyStorage(compound);
        this.saveDrainMode(compound);
    }

    protected final void saveTrades(CompoundTag compound) {
        EnergyTradeData.WriteNBTList(this.trades, compound);
    }

    protected final void saveDrainMode(CompoundTag compound) {
        compound.m_128405_("DrainMode", this.drainMode.index);
    }

    protected final void saveEnergyStorage(CompoundTag compound) {
        compound.m_128405_("Battery", this.energyStorage);
        compound.m_128405_("PendingDrain", this.pendingDrain);
    }

    public void loadAdditional(CompoundTag compound) {
        super.loadAdditional(compound);
        if (compound.m_128441_("Trades")) {
            this.trades = EnergyTradeData.LoadNBTList(compound, !this.isPersistent());
        }
        if (compound.m_128441_("Battery")) {
            this.energyStorage = Math.max(0, compound.m_128451_("Battery"));
        }
        if (compound.m_128441_("PendingDrain")) {
            this.pendingDrain = Math.max(0, compound.m_128451_("PendingDrain"));
        }
        if (compound.m_128441_("DrainMode")) {
            this.drainMode = DrainMode.of(compound.m_128451_("DrainMode"));
        }
    }

    public int getTradeCount() {
        return this.trades.size();
    }

    public EnergyTradeData getTrade(int tradeIndex) {
        if (tradeIndex >= 0 && tradeIndex < this.trades.size()) {
            return this.trades.get(tradeIndex);
        }
        return new EnergyTradeData(false);
    }

    @Nonnull
    public List<EnergyTradeData> getTradeData() {
        return new ArrayList<EnergyTradeData>(this.trades);
    }

    public TradeEnergyHandler getEnergyHandler() {
        return this.energyHandler;
    }

    public boolean canEditTradeCount() {
        return true;
    }

    public int getMaxTradeCount() {
        return 8;
    }

    public void addTrade(Player requestor) {
        if (this.isClient()) {
            return;
        }
        if (this.getTradeCount() >= 100) {
            return;
        }
        if (this.getTradeCount() >= 8 && !CommandLCAdmin.isAdminPlayer((Player)requestor)) {
            Permissions.PermissionWarning((Player)requestor, (String)"add creative trade slot", (String)"LC_ADMIN_MODE");
            return;
        }
        if (!this.hasPermission(requestor, "editTrades")) {
            Permissions.PermissionWarning((Player)requestor, (String)"add trade slot", (String)"editTrades");
            return;
        }
        this.overrideTradeCount(this.getTradeCount() + 1);
    }

    public void removeTrade(Player requestor) {
        if (this.isClient()) {
            return;
        }
        if (this.getTradeCount() <= 1) {
            return;
        }
        if (!this.hasPermission(requestor, "editTrades")) {
            Permissions.PermissionWarning((Player)requestor, (String)"remove trade slot", (String)"editTrades");
            return;
        }
        this.overrideTradeCount(this.getTradeCount() - 1);
    }

    public void overrideTradeCount(int newTradeCount) {
        if (this.getTradeCount() == newTradeCount) {
            return;
        }
        int tradeCount = MathUtil.clamp((int)newTradeCount, (int)1, (int)100);
        List<EnergyTradeData> oldTrades = this.trades;
        this.trades = EnergyTradeData.listOfSize(tradeCount, !this.isPersistent());
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        if (this.isServer()) {
            this.markDirty(new Consumer[]{this::saveTrades});
        }
    }

    public int getTradeStock(int tradeIndex) {
        return this.getTrade(tradeIndex).getStock(this);
    }

    public int getPendingDrain() {
        return Math.max(this.pendingDrain, 0);
    }

    private void setPendingDrain(int amount) {
        this.pendingDrain = Math.max(amount, 0);
    }

    public void addPendingDrain(int amount) {
        this.pendingDrain += amount;
    }

    public void shrinkPendingDrain(int amount) {
        this.setPendingDrain(this.pendingDrain - amount);
    }

    public int getAvailableEnergy() {
        return this.energyStorage - this.getPendingDrain();
    }

    public int getDrainableEnergy() {
        if (this.isAlwaysDrainMode()) {
            return this.isCreative() ? 0 : this.getAvailableEnergy();
        }
        if (this.isPurchaseDrainMode()) {
            return this.isCreative() ? this.pendingDrain : Math.min(this.pendingDrain, this.energyStorage);
        }
        return 0;
    }

    public int getTotalEnergy() {
        return this.energyStorage;
    }

    public static int getDefaultMaxEnergy() {
        return (Integer)TechConfig.SERVER.energyTraderDefaultStorage.get();
    }

    public int getMaxEnergy() {
        int defaultCapacity;
        int maxEnergy = defaultCapacity = EnergyTraderData.getDefaultMaxEnergy();
        boolean baseStorageCompensation = false;
        for (int i = 0; i < this.getUpgrades().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            int addAmount = upgradeItem.getDefaultUpgradeData().getIntValue(CapacityUpgrade.CAPACITY);
            if (addAmount > defaultCapacity && !baseStorageCompensation) {
                addAmount -= defaultCapacity;
                baseStorageCompensation = true;
            }
            maxEnergy += addAmount;
        }
        return maxEnergy;
    }

    public void shrinkEnergy(int amount) {
        this.energyStorage -= amount;
    }

    public void addEnergy(int amount) {
        this.energyStorage += amount;
    }

    public void markEnergyStorageDirty() {
        this.markDirty(new Consumer[]{this::saveEnergyStorage});
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction relativeSide) {
        return ForgeCapabilities.ENERGY.orEmpty(cap, LazyOptional.of(() -> this.getEnergyHandler().getExternalHandler(relativeSide)));
    }

    public IconData inputSettingsTabIcon() {
        return IconData.of((ItemStack)IBatteryItem.HideEnergyBar(ModItems.BATTERY));
    }

    public MutableComponent inputSettingsTabTooltip() {
        return Component.m_237115_((String)"tooltip.lctech.settings.energyinput");
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<InputTabAddon> inputSettingsAddons() {
        return ImmutableList.of((Object)((Object)EnergyInputAddon.INSTANCE));
    }

    public void receiveNetworkMessage(@NotNull Player player, @NotNull CompoundTag message) {
        DrainMode newMode;
        super.receiveNetworkMessage(player, message);
        if (message.m_128441_("NewEnergyDrainMode") && this.drainMode != (newMode = DrainMode.of(message.m_128451_("NewEnergyDrainMode")))) {
            this.drainMode = newMode;
            this.markDirty(new Consumer[]{this::saveDrainMode});
        }
    }

    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        EnergyTradeData trade = this.getTrade(tradeIndex);
        if (trade == null || !trade.isValid()) {
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!context.hasPlayerReference()) {
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (this.runPreTradeEvent(context.getPlayerReference(), trade).isCanceled()) {
            return TradeContext.TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        CoinValue price = this.runTradeCostEvent(context.getPlayerReference(), trade).getCostResult();
        if (!trade.hasStock(context) && !this.isCreative()) {
            return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
        }
        if (trade.isSale()) {
            if (!(context.canFitEnergy(trade.getAmount()) || this.drainCapable() && this.hasOutputSide() && this.isPurchaseDrainMode())) {
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.getPayment(price)) {
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            boolean drainStorage = true;
            if (context.canFitEnergy(trade.getAmount())) {
                context.fillEnergy(trade.getAmount());
            } else {
                this.addPendingDrain(trade.getAmount());
                drainStorage = false;
            }
            CoinValue taxesPaid = CoinValue.EMPTY;
            if (!this.isCreative()) {
                if (drainStorage) {
                    this.shrinkEnergy(trade.getAmount());
                    this.markEnergyStorageDirty();
                }
                taxesPaid = this.addStoredMoney(price, true);
            }
            this.pushNotification(EnergyTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(context.getPlayerReference(), trade, price, taxesPaid);
            return TradeContext.TradeResult.SUCCESS;
        }
        if (trade.isPurchase()) {
            if (!context.hasEnergy(trade.getAmount())) {
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this) && !this.isCreative()) {
                return TradeContext.TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!context.givePayment(price)) {
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.drainEnergy(trade.getAmount())) {
                context.getPayment(price);
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            CoinValue taxesPaid = CoinValue.EMPTY;
            if (!this.isCreative()) {
                this.addEnergy(trade.getAmount());
                this.markEnergyStorageDirty();
                taxesPaid = this.removeStoredMoney(price, true);
            }
            this.pushNotification(EnergyTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(context.getPlayerReference(), trade, price, taxesPaid);
            return TradeContext.TradeResult.SUCCESS;
        }
        return TradeContext.TradeResult.FAIL_INVALID_TRADE;
    }

    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
        interactionSlots.add(EnergyInteractionSlot.INSTANCE);
    }

    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    public boolean canMakePersistent() {
        return true;
    }

    protected void getAdditionalContents(List<ItemStack> contents) {
    }

    public IconData getIcon() {
        return IconData.of((ItemStack)IBatteryItem.HideEnergyBar((ItemLike)ModItems.BATTERY.get()));
    }

    public boolean hasValidTrade() {
        for (EnergyTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            return true;
        }
        return false;
    }

    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(1, (TraderStorageTab)new EnergyStorageTab(menu));
        menu.setTab(2, (TraderStorageTab)new EnergyTradeEditTab(menu));
    }

    protected void loadAdditionalFromJson(JsonObject json) throws Exception {
        if (!json.has("Trades")) {
            throw new Exception("Energy Trader must have a trade list.");
        }
        JsonArray tradeList = json.get("Trades").getAsJsonArray();
        this.trades = new ArrayList<EnergyTradeData>();
        for (int i = 0; i < tradeList.size() && this.trades.size() < 100; ++i) {
            try {
                JsonObject tradeData = tradeList.get(i).getAsJsonObject();
                EnergyTradeData newTrade = new EnergyTradeData(false);
                if (tradeData.has("TradeType")) {
                    newTrade.setTradeDirection(EnergyTradeData.loadTradeType(tradeData.get("TradeType").getAsString()));
                }
                newTrade.setAmount(tradeData.get("Quantity").getAsInt());
                newTrade.setCost(CoinValue.Parse((JsonElement)tradeData.get("Price")));
                if (tradeData.has("TradeRules")) {
                    newTrade.setRules(TradeRule.Parse((JsonArray)tradeData.get("TradeRules").getAsJsonArray(), (ITradeRuleHost)newTrade));
                }
                this.trades.add(newTrade);
                continue;
            }
            catch (Exception e) {
                LCTech.LOGGER.error("Error parsing energy trade at index " + i, (Throwable)e);
            }
        }
        if (this.trades.size() == 0) {
            throw new Exception("Trader has no valid trades!");
        }
        this.energyStorage = this.getMaxEnergy();
    }

    protected void saveAdditionalToJson(JsonObject json) {
        JsonArray trades = new JsonArray();
        for (EnergyTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            JsonObject tradeData = new JsonObject();
            tradeData.addProperty("TradeType", trade.getTradeDirection().name());
            tradeData.add("Price", (JsonElement)trade.getCost().toJson());
            tradeData.addProperty("Quantity", (Number)trade.getAmount());
            if (trade.getRules().size() > 0) {
                tradeData.add("TradeRules", (JsonElement)TradeRule.saveRulesToJson((List)trade.getRules()));
            }
            trades.add((JsonElement)tradeData);
        }
        json.add("Trades", (JsonElement)trades);
    }

    protected void saveAdditionalPersistentData(CompoundTag compound) {
        ListTag tradePersistentData = new ListTag();
        boolean tradesAreRelevant = false;
        Iterator<EnergyTradeData> iterator = this.trades.iterator();
        while (iterator.hasNext()) {
            CompoundTag ptTag = new CompoundTag();
            EnergyTradeData trade = iterator.next();
            if (TradeRule.savePersistentData((CompoundTag)ptTag, (List)trade.getRules(), (String)"RuleData")) {
                tradesAreRelevant = true;
            }
            tradePersistentData.add((Object)ptTag);
        }
        if (tradesAreRelevant) {
            compound.m_128365_("PersistentTradeData", (Tag)tradePersistentData);
        }
    }

    protected void loadAdditionalPersistentData(CompoundTag compound) {
        if (compound.m_128441_("PersistentTradeData")) {
            ListTag tradePersistentData = compound.m_128437_("PersistentTradeData", 10);
            for (int i = 0; i < tradePersistentData.size() && i < this.trades.size(); ++i) {
                EnergyTradeData trade = this.trades.get(i);
                CompoundTag ptTag = tradePersistentData.m_128728_(i);
                TradeRule.loadPersistentData((CompoundTag)ptTag, (List)trade.getRules(), (String)"RuleData");
            }
        }
    }

    public static List<Component> getEnergyHoverTooltip(EnergyTraderData trader) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(Component.m_237113_((String)(EnergyUtil.formatEnergyAmount(trader.getTotalEnergy()) + "/" + EnergyUtil.formatEnergyAmount(trader.getMaxEnergy()))).m_130940_(ChatFormatting.AQUA));
        if (trader.getPendingDrain() > 0) {
            tooltip.add(Component.m_237110_((String)"gui.lctech.energytrade.pending_drain", (Object[])new Object[]{EnergyUtil.formatEnergyAmount(trader.getPendingDrain())}).m_130940_(ChatFormatting.AQUA));
        }
        return tooltip;
    }

    public final boolean canDrainExternally() {
        return this.drainCapable() && this.hasOutputSide();
    }

    public static enum DrainMode {
        ALWAYS(0),
        PURCHASES_ONLY(1);

        public final int index;

        private DrainMode(int index) {
            this.index = index;
        }

        public static DrainMode of(int index) {
            for (DrainMode mode : DrainMode.values()) {
                if (mode.index != index) continue;
                return mode;
            }
            return ALWAYS;
        }
    }
}

