/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderstorage.fluid;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid.FluidTradeEditClientTab;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class FluidTradeEditTab
extends TraderStorageTab {
    int tradeIndex = -1;

    public FluidTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new FluidTradeEditClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return this.menu.getTrader().hasPermission(player, "editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public FluidTradeData getTrade() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (this.tradeIndex >= trader.getTradeCount() || this.tradeIndex < 0) {
                this.menu.changeTab(0);
                this.menu.sendMessage(this.menu.createTabChangeMessage(0, null));
                return null;
            }
            return trader.getTrade(this.tradeIndex);
        }
        return null;
    }

    public void onTabOpen() {
    }

    public void onTabClose() {
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void setType(TradeData.TradeDirection type) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTradeDirection(type);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("NewType", type.index);
                this.menu.sendMessage(message);
            }
        }
    }

    public void setQuantity(int amount) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setBucketQuantity(amount);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("NewQuantity", amount);
                this.menu.sendMessage(message);
            }
        }
    }

    public void setPrice(CoinValue price) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128365_("NewPrice", (Tag)price.save());
                this.menu.sendMessage(message);
            }
        }
    }

    public void setFluid(FluidStack fluid) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            FluidTraderData fluidTrader;
            trade.setProduct(fluid);
            this.menu.getTrader().markTradesDirty();
            TraderData traderData = this.menu.getTrader();
            if (traderData instanceof FluidTraderData && (fluidTrader = (FluidTraderData)traderData).getStorage().refactorTanks()) {
                fluidTrader.markStorageDirty();
            }
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                CompoundTag fluidTag = new CompoundTag();
                fluid.writeToNBT(fluidTag);
                message.m_128365_("NewFluid", (Tag)fluidTag);
                this.menu.sendMessage(message);
            }
        }
    }

    public void receiveMessage(CompoundTag message) {
        if (message.m_128441_("TradeIndex")) {
            this.tradeIndex = message.m_128451_("TradeIndex");
        } else if (message.m_128441_("NewFluid")) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)message.m_128469_("NewFluid")));
        } else if (message.m_128441_("NewQuantity")) {
            this.setQuantity(message.m_128451_("NewQuantity"));
        } else if (message.m_128441_("NewPrice")) {
            this.setPrice(CoinValue.safeLoad((CompoundTag)message, (String)"NewPrice"));
        } else if (message.m_128441_("NewType")) {
            this.setType(TradeData.TradeDirection.fromIndex((int)message.m_128451_("NewType")));
        }
    }
}

