/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderstorage.fluid;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid.FluidStorageClientTab;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidStorageTab
extends TraderStorageTab {
    List<SimpleSlot> slots = new ArrayList<SimpleSlot>();

    public FluidStorageTab(TraderStorageMenu menu) {
        super(menu);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new FluidStorageClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            for (int i = 0; i < trader.getUpgrades().m_6643_(); ++i) {
                UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(trader.getUpgrades(), i, 176, 18 + 18 * i, (UpgradeType.IUpgradeable)trader);
                upgradeSlot.active = false;
                addSlot.apply((Slot)upgradeSlot);
                this.slots.add((SimpleSlot)upgradeSlot);
            }
        }
    }

    public void onTabClose() {
        SimpleSlot.SetInactive(this.slots);
    }

    public void onTabOpen() {
        SimpleSlot.SetActive(this.slots);
    }

    public void interactWithTank(int tank, boolean shiftHeld) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            ItemStack heldStack;
            FluidTraderData trader = (FluidTraderData)traderData;
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("InteractWithTank", tank);
                message.m_128379_("ShiftHeld", shiftHeld);
                this.menu.sendMessage(message);
            }
            if ((heldStack = this.menu.m_142621_()).m_41619_()) {
                return;
            }
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)heldStack, (IFluidHandler)trader.getStorage(), (int)Integer.MAX_VALUE, (Player)this.menu.player, (boolean)true);
            if (result.isSuccess()) {
                if (this.menu.player.m_7500_() && result.getResult().m_41720_() == Items.f_42446_) {
                    if (shiftHeld) {
                        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)heldStack).orElse(FluidStack.EMPTY);
                        TraderFluidStorage.FluidEntry entry = trader.getStorage().getTank(fluid);
                        if (entry != null) {
                            entry.setAmount(trader.getTankCapacity());
                        }
                    }
                    trader.markStorageDirty();
                    return;
                }
                trader.markStorageDirty();
                if (heldStack.m_41613_() > 1) {
                    heldStack.m_41774_(1);
                    this.menu.m_142503_(heldStack);
                    ItemHandlerHelper.giveItemToPlayer((Player)this.menu.player, (ItemStack)result.getResult());
                } else {
                    this.menu.m_142503_(result.getResult());
                }
            } else {
                if (tank < 0 || tank >= trader.getStorage().getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry tankEntry = trader.getStorage().getContents().get(tank);
                result = FluidUtil.tryFillContainer((ItemStack)heldStack, (IFluidHandler)tankEntry, (int)Integer.MAX_VALUE, (Player)this.menu.player, (boolean)true);
                if (result.isSuccess()) {
                    if (this.menu.player.m_7500_() && heldStack.m_41720_() == Items.f_42446_) {
                        if (shiftHeld) {
                            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)result.getResult()).orElse(FluidStack.EMPTY);
                            TraderFluidStorage.FluidEntry entry = trader.getStorage().getTank(fluid);
                            if (entry != null) {
                                entry.setAmount(0);
                            }
                        }
                        trader.getStorage().clearInvalidTanks();
                        trader.markStorageDirty();
                        return;
                    }
                    trader.getStorage().clearInvalidTanks();
                    trader.markStorageDirty();
                    if (heldStack.m_41613_() > 1) {
                        heldStack.m_41774_(1);
                        this.menu.m_142503_(heldStack);
                        ItemHandlerHelper.giveItemToPlayer((Player)this.menu.player, (ItemStack)result.getResult());
                    } else {
                        this.menu.m_142503_(result.getResult());
                    }
                }
            }
        }
    }

    public void toggleDrainFillState(int tank, boolean drainState, boolean newValue) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (!trader.drainCapable()) {
                return;
            }
            if (tank < 0 || tank >= trader.getStorage().getTanks()) {
                return;
            }
            TraderFluidStorage.FluidEntry entry = trader.getStorage().getContents().get(tank);
            if (drainState) {
                entry.drainable = newValue;
            } else {
                entry.fillable = newValue;
            }
            trader.markStorageDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("ToggleDrainFillSlot", tank);
                message.m_128379_("DrainState", drainState);
                message.m_128379_("NewValue", newValue);
                this.menu.sendMessage(message);
            }
        }
    }

    public void receiveMessage(CompoundTag message) {
        if (message.m_128425_("InteractWithTank", 3)) {
            this.interactWithTank(message.m_128451_("InteractWithTank"), message.m_128471_("ShiftHeld"));
        } else if (message.m_128425_("ToggleDrainFillSlot", 3)) {
            int tank = message.m_128451_("ToggleDrainFillSlot");
            boolean drainState = message.m_128471_("DrainState");
            boolean newValue = message.m_128471_("NewValue");
            this.toggleDrainFillState(tank, drainState, newValue);
        }
    }
}

