/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderstorage.energy;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.energy.EnergyStorageClientTab;
import io.github.lightman314.lctech.common.menu.slots.BatteryInputSlot;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnergyStorageTab
extends TraderStorageTab {
    List<SimpleSlot> slots = new ArrayList<SimpleSlot>();
    BatteryInputSlot inputSlot;
    Container batterySlots = new SimpleContainer(2);

    public EnergyStorageTab(TraderStorageMenu menu) {
        super(menu);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new EnergyStorageClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof EnergyTraderData) {
            EnergyTraderData trader = (EnergyTraderData)traderData;
            for (int i = 0; i < trader.getUpgrades().m_6643_(); ++i) {
                UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(trader.getUpgrades(), i, 176, 18 + 18 * i, (UpgradeType.IUpgradeable)trader);
                upgradeSlot.active = false;
                addSlot.apply((Slot)upgradeSlot);
                this.slots.add((SimpleSlot)upgradeSlot);
            }
        }
        this.inputSlot = new BatteryInputSlot(this.batterySlots, 0, 23, 122);
        this.slots.add(this.inputSlot);
        addSlot.apply((Slot)this.inputSlot);
        this.inputSlot.locked = true;
        OutputSlot outputSlot = new OutputSlot(this.batterySlots, 1, 59, 122);
        this.slots.add((SimpleSlot)outputSlot);
        addSlot.apply((Slot)outputSlot);
        SimpleSlot.SetInactive(this.slots);
    }

    public void onTabClose() {
        SimpleSlot.SetInactive(this.slots);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.inputSlot.locked = true;
    }

    public void onMenuClose() {
        this.menu.clearContainer(this.batterySlots);
    }

    public void onTabOpen() {
        SimpleSlot.SetActive(this.slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.inputSlot.locked = false;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        TraderData traderData;
        if (event.side.isServer() && event.phase == TickEvent.Phase.START && (traderData = this.menu.getTrader()) instanceof EnergyTraderData) {
            EnergyTraderData trader = (EnergyTraderData)traderData;
            if (!this.batterySlots.m_8020_(0).m_41619_() && this.batterySlots.m_8020_(1).m_41619_()) {
                ItemStack batteryStack = this.batterySlots.m_8020_(0);
                ItemStack batteryOutput = trader.getEnergyHandler().batteryInteraction(batteryStack);
                if (batteryStack.m_41613_() > 1) {
                    batteryStack.m_41774_(1);
                } else {
                    batteryStack = ItemStack.f_41583_;
                }
                this.batterySlots.m_6836_(0, batteryStack);
                this.batterySlots.m_6836_(1, batteryOutput);
            }
        }
    }

    public void receiveMessage(CompoundTag message) {
    }
}

