/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items;

import io.github.lightman314.lctech.LCTech;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public interface IBatteryItem {
    public int getMaxEnergyStorage(ItemStack var1);

    public static ICapabilityProvider createCapability(ItemStack stack) {
        if (stack.m_41720_() instanceof IBatteryItem) {
            return new BatteryEnergyStorage(stack);
        }
        LCTech.LOGGER.warn("Attempted to make a battery storage capability for an item that doesn't implement IBatteryItem.");
        return null;
    }

    public static int getStoredEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("Battery", 3)) {
            return tag.m_128451_("Battery");
        }
        return 0;
    }

    public static <T extends IBatteryItem & ItemLike> ItemStack getFullBattery(T item) {
        ItemStack newStack = new ItemStack((ItemLike)item);
        newStack.m_41784_().m_128405_("Battery", item.getMaxEnergyStorage(newStack));
        return newStack;
    }

    public static ItemStack HideEnergyBar(RegistryObject<? extends ItemLike> item) {
        return IBatteryItem.HideEnergyBar(new ItemStack((ItemLike)item.get()));
    }

    public static ItemStack HideEnergyBar(ItemLike item) {
        return IBatteryItem.HideEnergyBar(new ItemStack(item));
    }

    public static ItemStack HideEnergyBar(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("HideEnergyBar", true);
        return stack;
    }

    public static boolean isEnergyBarVisible(ItemStack batteryStack) {
        if (batteryStack.m_41720_() instanceof IBatteryItem) {
            if (batteryStack.m_41782_()) {
                CompoundTag tag = batteryStack.m_41783_();
                return !tag.m_128441_("HideEnergyBar") || !tag.m_128471_("HideEnergyBar");
            }
            return true;
        }
        return false;
    }

    public static class BatteryEnergyStorage
    implements IEnergyStorage,
    ICapabilityProvider {
        private final ItemStack stack;
        private final LazyOptional<IEnergyStorage> optional;

        private BatteryEnergyStorage(ItemStack stack) {
            this.stack = stack;
            this.optional = LazyOptional.of(() -> this);
            if (this.getEnergyStored() == 0) {
                this.setEnergyStored(0);
            }
        }

        public ItemStack getContainer() {
            return this.stack;
        }

        private void setEnergyStored(int energyStored) {
            CompoundTag tag = this.stack.m_41784_();
            tag.m_128405_("Battery", energyStored);
            this.stack.m_41751_(tag);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int receiveAmount = Math.min(maxReceive, this.getMaxEnergyStored() - this.getEnergyStored());
            if (!simulate) {
                this.setEnergyStored(this.getEnergyStored() + receiveAmount);
            }
            return receiveAmount;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extractAmount = Math.min(maxExtract, this.getEnergyStored());
            if (!simulate) {
                this.setEnergyStored(this.getEnergyStored() - extractAmount);
            }
            return extractAmount;
        }

        public int getEnergyStored() {
            return IBatteryItem.getStoredEnergy(this.stack);
        }

        public int getMaxEnergyStored() {
            if (this.stack.m_41720_() instanceof IBatteryItem) {
                return ((IBatteryItem)this.stack.m_41720_()).getMaxEnergyStorage(this.stack);
            }
            return 0;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return ForgeCapabilities.ENERGY.orEmpty(cap, this.optional);
        }
    }
}

