/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.core;

import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.common.blocks.FluidTankBlock;
import io.github.lightman314.lctech.common.blocks.traderblocks.EnergyTraderBlock;
import io.github.lightman314.lctech.common.blocks.traderblocks.FluidTapBlock;
import io.github.lightman314.lctech.common.blocks.traderblocks.FluidTapBundleBlock;
import io.github.lightman314.lctech.common.blocks.traderblocks.NetworkEnergyTraderBlock;
import io.github.lightman314.lctech.common.blocks.traderblocks.NetworkFluidTraderBlock;
import io.github.lightman314.lctech.common.blocks.traderinterface.EnergyTraderInterfaceBlock;
import io.github.lightman314.lctech.common.blocks.traderinterface.FluidTraderInterfaceBlock;
import io.github.lightman314.lctech.common.core.ModRegistries;
import io.github.lightman314.lctech.common.items.FluidTankItem;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final RegistryObject<Block> IRON_TANK = ModBlocks.register("iron_tank", ModBlocks.getFluidTankGenerator(), () -> new FluidTankBlock(() -> (Integer)TechConfig.SERVER.ironTankCapacity.get() * 1000, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> GOLD_TANK = ModBlocks.register("gold_tank", ModBlocks.getFluidTankGenerator(), () -> new FluidTankBlock(() -> (Integer)TechConfig.SERVER.goldTankCapacity.get() * 1000, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> DIAMOND_TANK = ModBlocks.register("diamond_tank", ModBlocks.getFluidTankGenerator(), () -> new FluidTankBlock(() -> (Integer)TechConfig.SERVER.diamondTankCapacity.get() * 1000, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283821_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> FLUID_TAP = ModBlocks.register("fluid_tap", () -> new FluidTapBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)));
    public static final RegistryObject<Block> FLUID_TAP_BUNDLE = ModBlocks.register("fluid_tap_bundle", () -> new FluidTapBundleBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> FLUID_NETWORK_TRADER_1 = ModBlocks.register("fluid_trader_server_sml", () -> new NetworkFluidTraderBlock(2, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> FLUID_NETWORK_TRADER_2 = ModBlocks.register("fluid_trader_server_med", () -> new NetworkFluidTraderBlock(4, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> FLUID_NETWORK_TRADER_3 = ModBlocks.register("fluid_trader_server_lrg", () -> new NetworkFluidTraderBlock(6, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> FLUID_NETWORK_TRADER_4 = ModBlocks.register("fluid_trader_server_xlrg", () -> new NetworkFluidTraderBlock(8, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> FLUID_TRADER_INTERFACE = ModBlocks.register("fluid_trader_interface", () -> new FluidTraderInterfaceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> BATTERY_SHOP = ModBlocks.register("battery_shop", () -> new EnergyTraderBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> ENERGY_NETWORK_TRADER = ModBlocks.register("energy_trader_server", () -> new NetworkEnergyTraderBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> ENERGY_TRADER_INTERFACE = ModBlocks.register("energy_trader_interface", () -> new EnergyTraderInterfaceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));

    public static void init() {
    }

    private static Function<Block, Item> getDefaultGenerator() {
        return block -> new BlockItem(block, new Item.Properties());
    }

    private static Function<Block, Item> getFluidTankGenerator() {
        return block -> new FluidTankItem((Block)block, new Item.Properties());
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> sup) {
        return ModBlocks.register(name, ModBlocks.getDefaultGenerator(), sup);
    }

    private static RegistryObject<Block> register(String name, Function<Block, Item> itemGenerator, Supplier<Block> sup) {
        RegistryObject block = ModRegistries.BLOCKS.register(name, sup);
        if (block != null) {
            ModRegistries.ITEMS.register(name, () -> (Item)itemGenerator.apply((Block)block.get()));
        }
        return block;
    }
}

