/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blocks.traderblocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lctech.common.blockentities.trader.FluidTraderBlockEntity;
import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.items.tooltips.TechTooltips;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class NetworkFluidTraderBlock
extends TraderBlockRotatable {
    public static final int SMALL_SERVER_COUNT = 2;
    public static final int MEDIUM_SERVER_COUNT = 4;
    public static final int LARGE_SERVER_COUNT = 6;
    public static final int EXTRA_LARGE_SERVER_COUNT = 8;
    final int tradeCount;

    public NetworkFluidTraderBlock(int tradeCount, BlockBehaviour.Properties properties) {
        super(properties);
        this.tradeCount = tradeCount;
    }

    protected BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new FluidTraderBlockEntity(pos, state, this.tradeCount, true);
    }

    protected BlockEntityType<?> traderType() {
        return (BlockEntityType)ModBlockEntities.FLUID_TRADER.get();
    }

    protected List<BlockEntityType<?>> validTraderTypes() {
        return ImmutableList.of((Object)((BlockEntityType)ModBlockEntities.FLUID_TRADER.get()));
    }

    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, TechTooltips.FLUID_NETWORK_TRADER);
        super.m_5871_(stack, level, tooltip, flagIn);
    }
}

