/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blocks.traderblocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.lightman314.lctech.client.util.FluidRenderData;
import io.github.lightman314.lctech.client.util.FluidSides;
import io.github.lightman314.lctech.common.blockentities.trader.FluidTraderBlockEntity;
import io.github.lightman314.lctech.common.blocks.IFluidTraderBlock;
import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.items.tooltips.TechTooltips;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates.TraderBlockRotatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.NonNullSupplier;

public class FluidTapBundleBlock
extends TraderBlockRotatable
implements IFluidTraderBlock {
    public static final FluidRenderData FLUID_RENDER_NW = FluidRenderData.CreateFluidRender(0.01f, 0.01f, 0.01f, 7.98f, 15.98f, 7.98f, FluidSides.ALL);
    public static final FluidRenderData FLUID_RENDER_NE = FluidRenderData.CreateFluidRender(8.01f, 0.01f, 0.01f, 7.98f, 15.98f, 7.98f, FluidSides.ALL);
    public static final FluidRenderData FLUID_RENDER_SW = FluidRenderData.CreateFluidRender(0.01f, 0.01f, 8.01f, 7.98f, 15.98f, 7.98f, FluidSides.ALL);
    public static final FluidRenderData FLUID_RENDER_SE = FluidRenderData.CreateFluidRender(8.01f, 0.01f, 8.01f, 7.98f, 15.98f, 7.98f, FluidSides.ALL);
    public static final List<FluidRenderData> FLUID_RENDER = Lists.newArrayList((Object[])new FluidRenderData[]{FLUID_RENDER_NW, FLUID_RENDER_NE, FLUID_RENDER_SW, FLUID_RENDER_SE});
    private static List<Direction> IGNORELIST = Lists.newArrayList((Object[])new Direction[]{Direction.UP, Direction.DOWN});
    private static Map<Direction, List<FluidRenderData>> RENDERMAP = Maps.newHashMap();

    public FluidTapBundleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public FluidTapBundleBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties, shape);
    }

    protected BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new FluidTraderBlockEntity(pos, state, 4);
    }

    protected BlockEntityType<?> traderType() {
        return (BlockEntityType)ModBlockEntities.FLUID_TRADER.get();
    }

    @Override
    public int getTradeRenderLimit() {
        return 4;
    }

    @Override
    public FluidRenderData getRenderPosition(BlockState state, int index) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (!RENDERMAP.containsKey(facing)) {
            FluidTapBundleBlock.initRenderMap(facing);
        }
        if (RENDERMAP.containsKey(facing)) {
            List<FluidRenderData> renderList = RENDERMAP.get(facing);
            if (index < 0 || index >= renderList.size()) {
                return null;
            }
            return renderList.get(index);
        }
        return null;
    }

    private static void initRenderMap(Direction direction) {
        if (IGNORELIST.contains(direction)) {
            return;
        }
        List<Object> list = Lists.newArrayList();
        switch (direction) {
            case NORTH: {
                list = FluidTapBundleBlock.createList(0, 1, 2, 3);
                break;
            }
            case EAST: {
                list = FluidTapBundleBlock.createList(1, 3, 0, 2);
                break;
            }
            case SOUTH: {
                list = FluidTapBundleBlock.createList(3, 2, 1, 0);
                break;
            }
            case WEST: {
                list = FluidTapBundleBlock.createList(2, 0, 3, 1);
                break;
            }
        }
        if (list.size() > 0) {
            RENDERMAP.put(direction, list);
        } else {
            IGNORELIST.add(direction);
        }
    }

    private static List<FluidRenderData> createList(int ... indexes) {
        ArrayList list = Lists.newArrayList();
        for (int index : indexes) {
            if (index < 0 || index >= FLUID_RENDER.size()) continue;
            list.add(FLUID_RENDER.get(index));
        }
        return list;
    }

    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return TechTooltips.FLUID_TRADER;
    }
}

