/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities.trader;

import io.github.lightman314.lctech.client.util.FluidRenderData;
import io.github.lightman314.lctech.common.blocks.IFluidTraderBlock;
import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class FluidTraderBlockEntity
extends TraderBlockEntity<FluidTraderData> {
    protected int tradeCount;
    protected boolean networkTrader;

    public FluidTraderBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, 1, false);
    }

    public FluidTraderBlockEntity(BlockPos pos, BlockState state, int tradeCount) {
        this(pos, state, tradeCount, false);
    }

    public FluidTraderBlockEntity(BlockPos pos, BlockState state, int tradeCount, boolean networkTrader) {
        super((BlockEntityType)ModBlockEntities.FLUID_TRADER.get(), pos, state);
        this.tradeCount = tradeCount;
        this.networkTrader = networkTrader;
    }

    public FluidTraderData buildNewTrader() {
        FluidTraderData trader = new FluidTraderData(this.tradeCount, this.f_58857_, this.f_58858_);
        if (this.networkTrader) {
            trader.setAlwaysShowOnTerminal();
        }
        return trader;
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("TradeCount", this.tradeCount);
        compound.m_128379_("NetworkTrader", this.networkTrader);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.tradeCount = compound.m_128451_("TradeCount");
        this.networkTrader = compound.m_128471_("NetworkTrader");
    }

    public AABB getRenderBoundingBox() {
        if (this.m_58900_() != null) {
            return this.m_58900_().m_60812_((BlockGetter)this.f_58857_, this.f_58858_).m_83215_().m_82338_(this.f_58858_);
        }
        return super.getRenderBoundingBox();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTradeRenderLimit() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IFluidTraderBlock) {
            IFluidTraderBlock b = (IFluidTraderBlock)block;
            return b.getTradeRenderLimit();
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidRenderData getRenderPosition(int index) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IFluidTraderBlock) {
            IFluidTraderBlock b = (IFluidTraderBlock)block;
            return b.getRenderPosition(this.m_58900_(), index);
        }
        return null;
    }
}

