/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities.trader;

import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class EnergyTraderBlockEntity
extends TraderBlockEntity<EnergyTraderData> {
    protected boolean networkTrader;

    public EnergyTraderBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, false);
    }

    public EnergyTraderBlockEntity(BlockPos pos, BlockState state, boolean networkTrader) {
        super((BlockEntityType)ModBlockEntities.ENERGY_TRADER.get(), pos, state);
        this.networkTrader = networkTrader;
    }

    public EnergyTraderData buildNewTrader() {
        EnergyTraderData trader = new EnergyTraderData(this.f_58857_, this.f_58858_);
        if (this.networkTrader) {
            trader.setAlwaysShowOnTerminal();
        }
        return trader;
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("NetworkTrader", this.networkTrader);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.networkTrader = compound.m_128471_("NetworkTrader");
    }

    public AABB getRenderBoundingBox() {
        if (this.m_58900_() != null) {
            return this.m_58900_().m_60812_((BlockGetter)this.f_58857_, this.f_58858_).m_83215_().m_82338_(this.f_58858_);
        }
        return super.getRenderBoundingBox();
    }

    public void serverTick() {
        super.serverTick();
        EnergyTraderData trader = (EnergyTraderData)this.getTraderData();
        if (trader != null && trader.canDrainExternally() && trader.getDrainableEnergy() > 0) {
            for (Direction relativeSide : Direction.values()) {
                BlockEntity be;
                if (!trader.allowOutputSide(relativeSide) || trader.getDrainableEnergy() <= 0) continue;
                Direction actualSide = relativeSide;
                Block block = this.m_58900_().m_60734_();
                if (block instanceof IRotatableBlock) {
                    IRotatableBlock b = (IRotatableBlock)block;
                    actualSide = IRotatableBlock.getActualSide((Direction)b.getFacing(this.m_58900_()), (Direction)relativeSide);
                }
                if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(actualSide))) == null) continue;
                be.getCapability(ForgeCapabilities.ENERGY, actualSide.m_122424_()).ifPresent(energyHandler -> {
                    int extractedAmount = energyHandler.receiveEnergy(trader.getDrainableEnergy(), false);
                    if (extractedAmount > 0) {
                        if (trader.isPurchaseDrainMode()) {
                            trader.shrinkPendingDrain(extractedAmount);
                        }
                        trader.shrinkEnergy(extractedAmount);
                        trader.markEnergyStorageDirty();
                    }
                });
            }
        }
    }
}

