/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities.fluid_tank;

import io.github.lightman314.lctech.client.util.FluidRenderData;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.FluidTankFluidHandler;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.TankStackCache;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.TankStackState;
import io.github.lightman314.lctech.common.blocks.FluidTankBlock;
import io.github.lightman314.lctech.common.blocks.IFluidTankBlock;
import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.items.FluidTankItem;
import io.github.lightman314.lctech.network.LCTechPacketHandler;
import io.github.lightman314.lctech.network.message.fluid_tank.CMessageRequestTankStackSync;
import io.github.lightman314.lightmanscurrency.common.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.interfaces.tickable.IServerTicker;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class FluidTankBlockEntity
extends EasyBlockEntity
implements IServerTicker {
    public static final int DEFAULT_CAPACITY = 10000;
    FluidStack tankContents = FluidStack.EMPTY;
    private boolean refactorTankStack = false;
    private TankStackCache stackCache = TankStackCache.DUMMY;
    public final FluidTankFluidHandler handler = new FluidTankFluidHandler(this);
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.handler);

    public FluidStack getTankContents() {
        return this.tankContents;
    }

    public void setTankContents(@NotNull FluidStack newContents) {
        this.tankContents = newContents;
        this.m_6596_();
    }

    public int getTankCapacity() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof FluidTankBlock) {
            FluidTankBlock tankBlock = (FluidTankBlock)block;
            return tankBlock.getTankCapacity();
        }
        return 10000;
    }

    public double getTankFillPercent() {
        return (double)this.tankContents.getAmount() / (double)this.getTankCapacity();
    }

    public final void setTankStack(TankStackCache tankStack) {
        this.refactorTankStack = false;
        TankStackCache oldStack = this.stackCache;
        this.stackCache = tankStack;
        oldStack.refactorExcluded(this.stackCache);
    }

    public final void sendTankStackPacket(ServerPlayer player) {
        LCTechPacketHandler.instance.send(PacketDistributor.PLAYER.with(() -> player), this.stackCache.getSyncPacket());
    }

    public FluidTankBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.FLUID_TANK.get(), pos, state);
    }

    protected FluidTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public InteractionResult onInteraction(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
            return InteractionResult.PASS;
        }
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)heldItem, (IFluidHandler)this.handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        if (result.isSuccess()) {
            if (player.m_7500_() && (result.getResult().m_41720_() == Items.f_42446_ || heldItem.m_41720_() == Items.f_42446_)) {
                return InteractionResult.SUCCESS;
            }
            if (heldItem.m_41613_() > 1) {
                heldItem.m_41774_(1);
                player.m_21008_(hand, heldItem);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result.getResult());
            } else {
                player.m_21008_(hand, result.getResult());
            }
        } else {
            result = FluidUtil.tryFillContainer((ItemStack)heldItem, (IFluidHandler)this.handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            if (result.isSuccess()) {
                if (player.m_7500_() && (result.getResult().m_41720_() == Items.f_42446_ || heldItem.m_41720_() == Items.f_42446_)) {
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_41613_() > 1) {
                    heldItem.m_41774_(1);
                    player.m_21008_(hand, heldItem);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result.getResult());
                } else {
                    player.m_21008_(hand, result.getResult());
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6596_() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this);
            super.m_6596_();
        }
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("Tank", (Tag)this.tankContents.writeToNBT(new CompoundTag()));
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("Tank", 10)) {
            this.tankContents = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("Tank"));
        }
        super.m_142466_(compound);
    }

    public void loadFromItem(ItemStack stack) {
        this.tankContents = FluidTankItem.GetFluid(stack);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this);
        }
        this.m_6596_();
    }

    public FluidRenderData getRenderPosition() {
        Block block = this.f_58857_.m_8055_(this.f_58858_).m_60734_();
        if (block instanceof IFluidTankBlock) {
            IFluidTankBlock tankBlock = (IFluidTankBlock)block;
            return tankBlock.getRenderData(this.f_58857_.m_8055_(this.f_58858_), this.stackCache.isLighterThanAir(), this, this.stackCache.getTankAbove(this));
        }
        return null;
    }

    public void onLoad() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            BlockEntityUtil.requestUpdatePacket((Level)this.f_58857_, (BlockPos)this.f_58858_);
            LCTechPacketHandler.instance.sendToServer((Object)new CMessageRequestTankStackSync(this.f_58858_));
        } else if (this.stackCache == TankStackCache.DUMMY) {
            this.enqueTankStackRefactor();
        }
    }

    public void serverTick() {
        if (this.refactorTankStack) {
            this.refactorTankStack = false;
            this.refactorTankStack();
        }
    }

    public final void enqueTankStackRefactor() {
        this.refactorTankStack = true;
    }

    public final void refactorTankStack() {
        FluidTankBlockEntity tank;
        BlockPos queryPos;
        BlockEntity be;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        int bottomY = this.f_58858_.m_123342_();
        int topY = this.f_58858_.m_123342_();
        FluidStack mostRelevantFluid = this.tankContents.copy();
        while ((be = this.f_58857_.m_7702_(queryPos = this.f_58858_.m_175288_(bottomY - 1))) instanceof FluidTankBlockEntity && this.allowInStack(tank = (FluidTankBlockEntity)be, mostRelevantFluid)) {
            if (mostRelevantFluid.isEmpty()) {
                mostRelevantFluid = tank.getTankContents().copy();
            }
            bottomY = queryPos.m_123342_();
        }
        while ((be = this.f_58857_.m_7702_(queryPos = this.f_58858_.m_175288_(topY + 1))) instanceof FluidTankBlockEntity && this.allowInStack(tank = (FluidTankBlockEntity)be, mostRelevantFluid)) {
            if (mostRelevantFluid.isEmpty()) {
                mostRelevantFluid = tank.getTankContents().copy();
            }
            topY = queryPos.m_123342_();
        }
        if (bottomY == topY) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)FluidTankBlock.TANK_STATE, (Comparable)((Object)TankStackState.SOLO)));
            TankStackCache.solo(this).init(true);
        } else {
            this.f_58857_.m_46597_(this.f_58858_.m_175288_(bottomY), (BlockState)this.f_58857_.m_8055_(this.f_58858_.m_175288_(bottomY)).m_61124_((Property)FluidTankBlock.TANK_STATE, (Comparable)((Object)TankStackState.BOTTOM)));
            this.f_58857_.m_46597_(this.f_58858_.m_175288_(topY), (BlockState)this.f_58857_.m_8055_(this.f_58858_.m_175288_(topY)).m_61124_((Property)FluidTankBlock.TANK_STATE, (Comparable)((Object)TankStackState.TOP)));
            for (int y = bottomY + 1; y < topY; ++y) {
                BlockPos middlePos = new BlockPos(this.f_58858_.m_123341_(), y, this.f_58858_.m_123343_());
                this.f_58857_.m_46597_(middlePos, (BlockState)this.f_58857_.m_8055_(middlePos).m_61124_((Property)FluidTankBlock.TANK_STATE, (Comparable)((Object)TankStackState.MIDDLE)));
            }
            TankStackCache.create(this.f_58857_, this.f_58858_, bottomY, topY).init(true);
        }
    }

    private boolean allowInStack(FluidTankBlockEntity tank, FluidStack mostRelevantFluid) {
        if (tank.m_58900_().m_60734_() != this.m_58900_().m_60734_()) {
            return false;
        }
        FluidStack contents = tank.getTankContents();
        return contents.isFluidEqual(mostRelevantFluid) || contents.isEmpty() || mostRelevantFluid.isEmpty();
    }

    public final List<FluidTankBlockEntity> getTankStack() {
        return this.stackCache.getOrderedTanks();
    }

    public final List<FluidTankBlockEntity> getTankStack(FluidStack fluid) {
        return this.stackCache.getOrderedTanks(fluid);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }
}

