/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.common.blockentities.handler.EnergyInterfaceHandler;
import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.menu.traderinterface.energy.EnergyStorageTab;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lctech.common.upgrades.TechUpgradeTypes;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class EnergyTraderInterfaceBlockEntity
extends TraderInterfaceBlockEntity {
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{TechUpgradeTypes.ENERGY_CAPACITY});
    EnergyInterfaceHandler energyHandler = (EnergyInterfaceHandler)this.addHandler((SidedHandler)new EnergyInterfaceHandler(this));
    int energyStorage = 0;

    public EnergyInterfaceHandler getEnergyHandler() {
        return this.energyHandler;
    }

    public int getStoredEnergy() {
        return this.energyStorage;
    }

    public void addStoredEnergy(int amount) {
        this.energyStorage += amount;
        this.setEnergyBufferDirty();
    }

    public void drainStoredEnergy(int amount) {
        this.energyStorage -= amount;
        this.setEnergyBufferDirty();
    }

    public int getMaxEnergy() {
        int defaultCapacity;
        int capacity = defaultCapacity = EnergyTraderData.getDefaultMaxEnergy();
        boolean baseStorageCompensation = false;
        for (int i = 0; i < this.getUpgradeInventory().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgradeInventory().m_8020_(i);
            if (!(stack.m_41720_() instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)stack.m_41720_()) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            int addAmount = upgradeItem.getDefaultUpgradeData().getIntValue(CapacityUpgrade.CAPACITY);
            if (addAmount > defaultCapacity && !baseStorageCompensation) {
                addAmount -= defaultCapacity;
                baseStorageCompensation = true;
            }
            capacity += addAmount;
        }
        return capacity;
    }

    public EnergyTraderInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRADER_INTERFACE_ENERGY.get(), pos, state);
    }

    public List<TraderInterfaceBlockEntity.InteractionType> getBlacklistedInteractions() {
        return Lists.newArrayList((Object[])new TraderInterfaceBlockEntity.InteractionType[]{TraderInterfaceBlockEntity.InteractionType.RESTOCK_AND_DRAIN});
    }

    public TradeContext.Builder buildTradeContext(TradeContext.Builder baseContext) {
        return baseContext.withEnergyHandler(this.energyHandler.tradeHandler);
    }

    protected TradeData deserializeTrade(CompoundTag compound) {
        return EnergyTradeData.loadData(compound, false);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveEnergyBuffer(compound);
    }

    protected final CompoundTag saveEnergyBuffer(CompoundTag compound) {
        compound.m_128405_("Energy", this.energyStorage);
        return compound;
    }

    public void setEnergyBufferDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, (CompoundTag)this.saveEnergyBuffer(new CompoundTag()));
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Energy")) {
            this.energyStorage = compound.m_128451_("Energy");
        }
    }

    public boolean validTraderType(TraderData trader) {
        return trader instanceof EnergyTraderData;
    }

    protected final EnergyTraderData getEnergyTrader() {
        TraderData trader = this.getTrader();
        if (trader instanceof EnergyTraderData) {
            return (EnergyTraderData)trader;
        }
        return null;
    }

    protected void drainTick() {
        int drainableAmount;
        EnergyTraderData trader = this.getEnergyTrader();
        if (trader != null && trader.hasPermission(this.getReferencedPlayer(), "interactionLink") && (drainableAmount = Math.min(this.getMaxEnergy() - this.getStoredEnergy(), trader.getAvailableEnergy())) > 0) {
            drainableAmount = Math.min(drainableAmount, (Integer)TechConfig.SERVER.energyRestockSpeed.get());
            trader.shrinkEnergy(drainableAmount);
            trader.markEnergyStorageDirty();
            this.addStoredEnergy(drainableAmount);
        }
    }

    protected void restockTick() {
        int restockableAmount;
        EnergyTraderData trader = this.getEnergyTrader();
        if (trader != null && trader.hasPermission(this.getReferencedPlayer(), "interactionLink") && (restockableAmount = Math.min(this.getStoredEnergy(), trader.getMaxEnergy() - trader.getTotalEnergy())) > 0) {
            restockableAmount = Math.min(restockableAmount, (Integer)TechConfig.SERVER.energyRestockSpeed.get());
            trader.addEnergy(restockableAmount);
            trader.markEnergyStorageDirty();
            this.drainStoredEnergy(restockableAmount);
        }
    }

    protected void tradeTick() {
        EnergyTradeData trade;
        TradeData t = this.getTrueTrade();
        if (t instanceof EnergyTradeData && (trade = (EnergyTradeData)t) != null && trade.isValid()) {
            if (trade.isSale()) {
                if (this.getMaxEnergy() - this.energyStorage >= trade.getAmount()) {
                    this.interactWithTrader();
                    this.setEnergyBufferDirty();
                }
            } else if (trade.isPurchase() && this.energyStorage >= trade.getAmount()) {
                this.interactWithTrader();
                this.setEnergyBufferDirty();
            }
        }
    }

    public void serverTick() {
        super.serverTick();
        if (this.energyStorage > 0) {
            for (Direction direction : Direction.values()) {
                Direction trueSide;
                BlockEntity be;
                if (!this.energyHandler.getOutputSides().get(direction) || this.energyStorage <= 0 || (be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(trueSide = this.m_58900_().m_60734_() instanceof IRotatableBlock ? IRotatableBlock.getActualSide((Direction)((IRotatableBlock)this.m_58900_().m_60734_()).getFacing(this.m_58900_()), (Direction)direction) : direction))) == null) continue;
                be.getCapability(ForgeCapabilities.ENERGY, trueSide.m_122424_()).ifPresent(energyHandler -> {
                    int extractedAmount = energyHandler.receiveEnergy(this.energyStorage, false);
                    if (extractedAmount > 0) {
                        this.drainStoredEnergy(extractedAmount);
                    }
                });
            }
        }
    }

    protected void hopperTick() {
        AtomicBoolean markBufferDirty = new AtomicBoolean(false);
        for (Direction relativeSide : Direction.values()) {
            BlockPos queryPos;
            BlockEntity be;
            if (!this.energyHandler.getInputSides().get(relativeSide)) continue;
            Direction actualSide = relativeSide;
            if (this.m_58900_().m_60734_() instanceof IRotatableBlock) {
                IRotatableBlock b = (IRotatableBlock)this.m_58900_().m_60734_();
                actualSide = IRotatableBlock.getActualSide((Direction)b.getFacing(this.m_58900_()), (Direction)relativeSide);
            }
            if ((be = this.f_58857_.m_7702_(queryPos = this.f_58858_.m_121945_(actualSide))) == null) continue;
            be.getCapability(ForgeCapabilities.ENERGY, actualSide.m_122424_()).ifPresent(energyHandler -> {
                int extractedAmount = energyHandler.extractEnergy(this.getMaxEnergy() - this.energyStorage, false);
                if (extractedAmount > 0) {
                    this.energyStorage += extractedAmount;
                    markBufferDirty.set(true);
                }
            });
        }
        if (markBufferDirty.get()) {
            this.setEnergyBufferDirty();
        }
    }

    public void initMenuTabs(TraderInterfaceMenu menu) {
        menu.setTab(1, (TraderInterfaceTab)new EnergyStorageTab(menu));
    }

    public boolean allowAdditionalUpgrade(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    public void getAdditionalContents(List<ItemStack> contents) {
    }

    public MutableComponent getName() {
        return Component.m_237115_((String)"block.lctech.energy_trader_interface");
    }
}

