/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.settings.energy;

import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.input.InputTabAddon;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public class EnergyInputAddon
extends InputTabAddon {
    public static final EnergyInputAddon INSTANCE = new EnergyInputAddon();
    EasyButton buttonDrainMode;

    private EnergyInputAddon() {
    }

    public void onOpen(SettingsSubTab settingsSubTab, ScreenArea screenArea, boolean firstOpen) {
        this.buttonDrainMode = (EasyButton)settingsSubTab.addChild((Object)new EasyTextButton(screenArea.pos.offset(20, 100), settingsSubTab.screen.getXSize() - 40, 20, this.getOutputModeTextSource(settingsSubTab), b -> this.ToggleDrainMode(settingsSubTab)));
        this.tick(settingsSubTab);
    }

    public void renderBG(@Nonnull SettingsSubTab settingsSubTab, @Nonnull EasyGuiGraphics easyGuiGraphics) {
    }

    public void renderAfterWidgets(@Nonnull SettingsSubTab settingsSubTab, @Nonnull EasyGuiGraphics easyGuiGraphics) {
    }

    public void tick(SettingsSubTab settingsSubTab) {
        TraderData trader = settingsSubTab.menu.getTrader();
        if (trader instanceof EnergyTraderData) {
            EnergyTraderData e = (EnergyTraderData)trader;
            this.buttonDrainMode.f_93624_ = e.drainCapable();
        } else {
            this.buttonDrainMode.f_93624_ = false;
        }
    }

    public void onClose(@Nonnull SettingsSubTab settingsSubTab) {
    }

    private NonNullSupplier<Component> getOutputModeTextSource(SettingsSubTab settingsSubTab) {
        return () -> EasyText.translatable((String)"gui.lctech.settings.energy.drainmode", (Object[])new Object[]{this.getOutputModeText(settingsSubTab)});
    }

    private MutableComponent getOutputModeText(SettingsSubTab settingsSubTab) {
        TraderData trader = settingsSubTab.menu.getTrader();
        if (trader instanceof EnergyTraderData) {
            EnergyTraderData e = (EnergyTraderData)trader;
            if (e.isAlwaysDrainMode()) {
                return Component.m_237115_((String)"gui.lctech.settings.energy.drainmode.full");
            }
            return Component.m_237115_((String)"gui.lctech.settings.energy.drainmode.sales");
        }
        return Component.m_237113_((String)"NULL");
    }

    private void ToggleDrainMode(SettingsSubTab settingsSubTab) {
        TraderData trader = settingsSubTab.menu.getTrader();
        if (trader instanceof EnergyTraderData) {
            EnergyTraderData e = (EnergyTraderData)trader;
            CompoundTag message = new CompoundTag();
            message.m_128405_("NewEnergyDrainMode", e.getDrainMode().index + 1);
            e.sendNetworkMessage(message);
        }
    }
}

