/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client;

import com.google.common.base.Function;
import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.client.models.items.FluidShardModel;
import io.github.lightman314.lctech.client.models.items.FluidTankModel;
import io.github.lightman314.lctech.common.items.FluidShardItem;
import io.github.lightman314.lctech.common.items.FluidTankItem;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lctech", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        FluidTankItem.getTankModelList().forEach(itemModelResourceLocation -> ClientModEvents.replaceModel(itemModelResourceLocation, event.getModels(), (Function<BakedModel, BakedModel>)((Function)FluidTankModel::new)));
        FluidShardItem.getShardModelList().forEach(itemModelResourceLocation -> ClientModEvents.replaceModel(itemModelResourceLocation, event.getModels(), (Function<BakedModel, BakedModel>)((Function)FluidShardModel::new)));
    }

    private static void replaceModel(ModelResourceLocation itemModelResourceLocation, Map<ResourceLocation, BakedModel> modelRegistry, Function<BakedModel, BakedModel> modelGenerator) {
        BakedModel existingModel = modelRegistry.get(itemModelResourceLocation);
        if (existingModel == null) {
            LCTech.LOGGER.warn("Did not find the expected vanilla baked model for FluidTankModel in registry.");
        } else {
            BakedModel customModel = (BakedModel)modelGenerator.apply((Object)existingModel);
            modelRegistry.put((ResourceLocation)itemModelResourceLocation, customModel);
        }
    }
}

