/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import mcjty.lib.api.container.IContainerDataListener;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class PacketContainerDataToClient {
    private final ResourceLocation id;
    private final FriendlyByteBuf buffer;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
        int l = this.buffer.array().length;
        buf.writeInt(l);
        buf.writeBytes(this.buffer.array());
    }

    public PacketContainerDataToClient(FriendlyByteBuf buf) {
        this.id = buf.m_130281_();
        int l = buf.readInt();
        ByteBuf newbuf = Unpooled.buffer((int)l);
        byte[] bytes = new byte[l];
        buf.readBytes(bytes);
        newbuf.writeBytes(bytes);
        this.buffer = new FriendlyByteBuf(newbuf);
    }

    public PacketContainerDataToClient(ResourceLocation id, FriendlyByteBuf buffer) {
        this.id = id;
        this.buffer = buffer;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            GenericContainer gc;
            IContainerDataListener listener;
            AbstractContainerMenu container = SafeClientTools.getClientPlayer().f_36096_;
            if (container instanceof GenericContainer && (listener = (gc = (GenericContainer)container).getListener(this.id)) != null) {
                listener.readBuf(this.buffer);
            }
        });
        ctx.setPacketHandled(true);
    }
}

